"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorStatusHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _contexts = require("../../../contexts");
var _use_selected_location = require("../hooks/use_selected_location");
var _runtime_types = require("../../../../../../common/runtime_types");
var _constants = require("../../../../../../common/constants");
var _url_params = require("../../../utils/url_params");
var _use_selected_monitor = require("../hooks/use_selected_monitor");
var labels = _interopRequireWildcard(require("./labels"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorStatusHeader = ({
  from,
  to,
  periodCaption,
  showViewHistoryButton
}) => {
  var _monitor$ConfigKey$CO;
  const {
    basePath
  } = (0, _contexts.useSyntheticsSettingsContext)();
  const {
    monitor
  } = (0, _use_selected_monitor.useSelectedMonitor)();
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)();
  const search = (0, _url_params.stringifyUrlParams)({
    locationId: selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.id,
    dateRangeStart: 'now-24h',
    dateRangeEnd: 'now'
  });
  const viewDetailsUrl = `${basePath}/app/synthetics${_constants.MONITOR_HISTORY_ROUTE.replace(':monitorId', (_monitor$ConfigKey$CO = monitor === null || monitor === void 0 ? void 0 : monitor[_runtime_types.ConfigKey.CONFIG_ID]) !== null && _monitor$ConfigKey$CO !== void 0 ? _monitor$ConfigKey$CO : '')}${search}`;
  const isLast24Hours = from === 'now-24h' && to === 'now';
  const periodCaptionText = !!periodCaption ? periodCaption : isLast24Hours ? labels.LAST_24_HOURS_LABEL : '';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "baseline",
    css: {
      marginBottom: 0
    },
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    wrap: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, labels.STATUS_LABEL))), periodCaptionText ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, periodCaptionText)) : null), showViewHistoryButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    css: {
      marginLeft: 'auto'
    },
    href: viewDetailsUrl,
    "data-test-subj": "monitorStatusChartViewHistoryButton",
    size: "xs",
    iconType: "list"
  }, labels.VIEW_HISTORY_LABEL) : null);
};
exports.MonitorStatusHeader = MonitorStatusHeader;