"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorDetailsLocation = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/kibana-react-plugin/public");
var _hooks = require("../../hooks");
var _constants = require("../../../../../common/constants");
var _plugin = require("../../../../../common/constants/plugin");
var _use_selected_location = require("./hooks/use_selected_location");
var _monitor_location_select = require("../common/components/monitor_location_select");
var _use_selected_monitor = require("./hooks/use_selected_monitor");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorDetailsLocation = ({
  isDisabled
}) => {
  const {
    monitor
  } = (0, _use_selected_monitor.useSelectedMonitor)();
  const {
    monitorId
  } = (0, _reactRouterDom.useParams)();
  const {
    dateRangeStart,
    dateRangeEnd
  } = (0, _hooks.useGetUrlParams)();
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)();
  const {
    services
  } = (0, _public.useKibana)();
  const isErrorsTab = (0, _reactRouterDom.useRouteMatch)(_constants.MONITOR_ERRORS_ROUTE);
  const isHistoryTab = (0, _reactRouterDom.useRouteMatch)(_constants.MONITOR_HISTORY_ROUTE);
  const params = `&dateRangeStart=${dateRangeStart}&dateRangeEnd=${dateRangeEnd}`;
  return /*#__PURE__*/_react.default.createElement(_monitor_location_select.MonitorLocationSelect, {
    isDisabled: isDisabled,
    monitorLocations: monitor === null || monitor === void 0 ? void 0 : monitor.locations,
    configId: monitorId,
    selectedLocation: selectedLocation,
    onChange: (0, _react.useCallback)((id, label) => {
      if (isErrorsTab) {
        services.application.navigateToApp(_plugin.PLUGIN.SYNTHETICS_PLUGIN_ID, {
          path: `/monitor/${monitorId}/errors?locationId=${id}${params}`
        });
      } else if (isHistoryTab) {
        services.application.navigateToApp(_plugin.PLUGIN.SYNTHETICS_PLUGIN_ID, {
          path: `/monitor/${monitorId}/history/?locationId=${id}${params}`
        });
      } else {
        services.application.navigateToApp(_plugin.PLUGIN.SYNTHETICS_PLUGIN_ID, {
          path: `/monitor/${monitorId}?locationId=${id}${params}`
        });
      }
    }, [isErrorsTab, isHistoryTab, monitorId, params, services.application])
  });
};
exports.MonitorDetailsLocation = MonitorDetailsLocation;