"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorAddPageWithServiceAllowed = exports.MonitorAddPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _public = require("@kbn/observability-shared-plugin/public");
var _hooks = require("../../hooks");
var _state = require("../../state");
var _service_allowed_wrapper = require("../common/wrappers/service_allowed_wrapper");
var _hooks2 = require("./hooks");
var _steps = require("./steps");
var _form = require("./form");
var _locations_loading_error = require("./locations_loading_error");
var _step_config = require("./steps/step_config");
var _use_breadcrumbs = require("./use_breadcrumbs");
var _monitor_detail_flyout = require("../monitors_page/overview/overview/monitor_detail_flyout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorAddPage = () => {
  (0, _public.useTrackPageview)({
    app: 'synthetics',
    path: 'add-monitor'
  });
  const {
    space
  } = (0, _hooks2.useKibanaSpace)();
  (0, _public.useTrackPageview)({
    app: 'synthetics',
    path: 'add-monitor',
    delay: 15000
  });
  (0, _use_breadcrumbs.useMonitorAddEditBreadcrumbs)();
  (0, _hooks.useEnablement)();
  const dispatch = (0, _reactRedux.useDispatch)();
  (0, _react.useEffect)(() => {
    dispatch((0, _state.getServiceLocations)());
  }, [dispatch]);
  const {
    locationsLoaded,
    error: locationsError
  } = (0, _reactRedux.useSelector)(_state.selectServiceLocationsState);
  if (locationsError) {
    return /*#__PURE__*/_react.default.createElement(_locations_loading_error.LocationsLoadingError, null);
  }
  return locationsLoaded ? /*#__PURE__*/_react.default.createElement(_form.MonitorForm, {
    space: space === null || space === void 0 ? void 0 : space.id
  }, /*#__PURE__*/_react.default.createElement(_steps.MonitorSteps, {
    stepMap: _step_config.ADD_MONITOR_STEPS
  })) : /*#__PURE__*/_react.default.createElement(_monitor_detail_flyout.LoadingState, null);
};
exports.MonitorAddPage = MonitorAddPage;
const MonitorAddPageWithServiceAllowed = /*#__PURE__*/_react.default.memo(() => /*#__PURE__*/_react.default.createElement(_service_allowed_wrapper.ServiceAllowedWrapper, null, /*#__PURE__*/_react.default.createElement(MonitorAddPage, null)));
exports.MonitorAddPageWithServiceAllowed = MonitorAddPageWithServiceAllowed;