"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TCP_ADVANCED = exports.ICMP_ADVANCED = exports.FORM_CONFIG = exports.BROWSER_ADVANCED = void 0;
var _i18n = require("@kbn/i18n");
var _types = require("../types");
var _constants = require("../constants");
var _field_config = require("./field_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_DATA_OPTIONS = readOnly => ({
  title: _i18n.i18n.translate('xpack.synthetics.monitorConfig.section.dataOptions.title', {
    defaultMessage: 'Data options'
  }),
  description: _i18n.i18n.translate('xpack.synthetics.monitorConfig.section.dataOptions.description', {
    defaultMessage: 'Configure data options to add context to the data coming from your monitors.'
  }),
  components: [(0, _field_config.FIELD)(readOnly)[_types.ConfigKey.TAGS], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.APM_SERVICE_NAME], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.NAMESPACE]]
});
const HTTP_ADVANCED = readOnly => ({
  requestConfig: {
    title: _i18n.i18n.translate('xpack.synthetics.monitorConfig.section.requestConfiguration.title', {
      defaultMessage: 'Request configuration'
    }),
    description: _i18n.i18n.translate('xpack.synthetics.monitorConfig.section.requestConfiguration.description', {
      defaultMessage: 'Configure an optional request to send to the remote host including method, body, and headers.'
    }),
    components: [(0, _field_config.FIELD)(readOnly)[_types.ConfigKey.USERNAME], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.PASSWORD], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.REQUEST_METHOD_CHECK], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.REQUEST_HEADERS_CHECK], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.REQUEST_BODY_CHECK], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.PROXY_URL], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.PROXY_HEADERS], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.MODE], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.IPV4]]
  },
  responseConfig: {
    title: _i18n.i18n.translate('xpack.synthetics.monitorConfig.section.responseConfiguration.title', {
      defaultMessage: 'Response configuration'
    }),
    description: _i18n.i18n.translate('xpack.synthetics.monitorConfig.section.responseConfiguration.description', {
      defaultMessage: 'Control the indexing of the HTTP response contents.'
    }),
    components: [(0, _field_config.FIELD)(readOnly)[_types.ConfigKey.RESPONSE_HEADERS_INDEX], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.RESPONSE_BODY_INDEX], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.RESPONSE_BODY_MAX_BYTES]]
  },
  responseChecks: {
    title: _i18n.i18n.translate('xpack.synthetics.monitorConfig.section.responseChecks.title', {
      defaultMessage: 'Response checks'
    }),
    description: _i18n.i18n.translate('xpack.synthetics.monitorConfig.section.responseChecks.description', {
      defaultMessage: 'Configure the expected HTTP response.'
    }),
    components: [(0, _field_config.FIELD)(readOnly)[_types.ConfigKey.RESPONSE_STATUS_CHECK], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.RESPONSE_HEADERS_CHECK], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.RESPONSE_BODY_CHECK_POSITIVE], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.RESPONSE_BODY_CHECK_NEGATIVE], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.RESPONSE_JSON_CHECK]]
  }
});
const TCP_ADVANCED = readOnly => ({
  requestConfig: {
    title: _i18n.i18n.translate('xpack.synthetics.monitorConfig.section.requestConfigTCP.title', {
      defaultMessage: 'Request configuration'
    }),
    description: _i18n.i18n.translate('xpack.synthetics.monitorConfig.section.requestConfigTCP.description', {
      defaultMessage: 'Configure the payload sent to the remote host.'
    }),
    components: [(0, _field_config.FIELD)(readOnly)[`${_types.ConfigKey.PROXY_URL}__tcp`], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.REQUEST_SEND_CHECK], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.MODE], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.IPV4]]
  },
  responseChecks: {
    title: _i18n.i18n.translate('xpack.synthetics.monitorConfig.section.responseChecksTCP.title', {
      defaultMessage: 'Response checks'
    }),
    description: _i18n.i18n.translate('xpack.synthetics.monitorConfig.section.responseChecksTCP.description', {
      defaultMessage: 'Configure the expected response from the remote host.'
    }),
    components: [(0, _field_config.FIELD)(readOnly)[_types.ConfigKey.RESPONSE_RECEIVE_CHECK]]
  }
});
exports.TCP_ADVANCED = TCP_ADVANCED;
const ICMP_ADVANCED = readOnly => ({
  requestConfig: {
    title: _i18n.i18n.translate('xpack.synthetics.monitorConfig.section.requestConfigICMP.title', {
      defaultMessage: 'Request configuration'
    }),
    description: _i18n.i18n.translate('xpack.synthetics.monitorConfig.section.requestConfigICMP.description', {
      defaultMessage: 'Configure the payload sent to the remote host.'
    }),
    components: [(0, _field_config.FIELD)(readOnly)[_types.ConfigKey.MODE], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.IPV4]]
  }
});
exports.ICMP_ADVANCED = ICMP_ADVANCED;
const BROWSER_ADVANCED = readOnly => [{
  title: _i18n.i18n.translate('xpack.synthetics.monitorConfig.section.syntAgentOptions.title', {
    defaultMessage: 'Synthetics agent options'
  }),
  description: _i18n.i18n.translate('xpack.synthetics.monitorConfig.section.syntAgentOptions.description', {
    defaultMessage: 'Provide fine-tuned configuration for the synthetics agent.'
  }),
  components: [(0, _field_config.FIELD)(readOnly)[_types.ConfigKey.THROTTLING_CONFIG], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.IGNORE_HTTPS_ERRORS], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.SYNTHETICS_ARGS], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.PLAYWRIGHT_OPTIONS]]
}];
exports.BROWSER_ADVANCED = BROWSER_ADVANCED;
const TLS_OPTIONS = readOnly => ({
  title: _i18n.i18n.translate('xpack.synthetics.monitorConfig.section.tlsOptions.title', {
    defaultMessage: 'TLS options'
  }),
  description: _i18n.i18n.translate('xpack.synthetics.monitorConfig.section.tlsOptions.description', {
    defaultMessage: 'Configure TLS options, including verification mode, certificate authorities, and client certificates.'
  }),
  components: [(0, _field_config.FIELD)(readOnly).isTLSEnabled, (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.TLS_VERIFICATION_MODE], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.TLS_VERSION], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.TLS_CERTIFICATE_AUTHORITIES], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.TLS_CERTIFICATE], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.TLS_KEY], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.TLS_KEY_PASSPHRASE]]
});
const FORM_CONFIG = readOnly => ({
  [_types.FormMonitorType.HTTP]: {
    step1: [(0, _field_config.FIELD)(readOnly)[_types.ConfigKey.FORM_MONITOR_TYPE]],
    step2: [(0, _field_config.FIELD)(readOnly)[`${_types.ConfigKey.URLS}__http`], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.NAME], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.LOCATIONS], (0, _field_config.FIELD)(readOnly)[`${_types.ConfigKey.SCHEDULE}.number`], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.MAX_REDIRECTS], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.TIMEOUT], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.ENABLED], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.MAX_ATTEMPTS], (0, _field_config.FIELD)(readOnly)[_constants.AlertConfigKey.STATUS_ENABLED], (0, _field_config.FIELD)(readOnly)[_constants.AlertConfigKey.TLS_ENABLED]],
    advanced: [DEFAULT_DATA_OPTIONS(readOnly), HTTP_ADVANCED(readOnly).requestConfig, HTTP_ADVANCED(readOnly).responseConfig, HTTP_ADVANCED(readOnly).responseChecks, TLS_OPTIONS(readOnly)]
  },
  [_types.FormMonitorType.TCP]: {
    step1: [(0, _field_config.FIELD)(readOnly)[_types.ConfigKey.FORM_MONITOR_TYPE]],
    step2: [(0, _field_config.FIELD)(readOnly)[`${_types.ConfigKey.HOSTS}__tcp`], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.NAME], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.LOCATIONS], (0, _field_config.FIELD)(readOnly)[`${_types.ConfigKey.SCHEDULE}.number`], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.TIMEOUT], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.ENABLED], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.MAX_ATTEMPTS], (0, _field_config.FIELD)(readOnly)[_constants.AlertConfigKey.STATUS_ENABLED], (0, _field_config.FIELD)(readOnly)[_constants.AlertConfigKey.TLS_ENABLED]],
    advanced: [DEFAULT_DATA_OPTIONS(readOnly), TCP_ADVANCED(readOnly).requestConfig, TCP_ADVANCED(readOnly).responseChecks, TLS_OPTIONS(readOnly)]
  },
  [_types.FormMonitorType.MULTISTEP]: {
    step1: [(0, _field_config.FIELD)(readOnly)[_types.ConfigKey.FORM_MONITOR_TYPE]],
    step2: [(0, _field_config.FIELD)(readOnly)[_types.ConfigKey.NAME], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.LOCATIONS], (0, _field_config.FIELD)(readOnly)[`${_types.ConfigKey.SCHEDULE}.number`], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.ENABLED], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.MAX_ATTEMPTS], (0, _field_config.FIELD)(readOnly)[_constants.AlertConfigKey.STATUS_ENABLED]],
    step3: [(0, _field_config.FIELD)(readOnly)['source.inline'], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.PARAMS]],
    scriptEdit: [(0, _field_config.FIELD)(readOnly)['source.inline'], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.PARAMS]],
    advanced: [{
      ...DEFAULT_DATA_OPTIONS(readOnly),
      components: [(0, _field_config.FIELD)(readOnly)[_types.ConfigKey.TAGS], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.APM_SERVICE_NAME], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.SCREENSHOTS], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.NAMESPACE]]
    }, ...BROWSER_ADVANCED(readOnly)]
  },
  [_types.FormMonitorType.SINGLE]: {
    step1: [(0, _field_config.FIELD)(readOnly)[_types.ConfigKey.FORM_MONITOR_TYPE]],
    step2: [(0, _field_config.FIELD)(readOnly)[`${_types.ConfigKey.URLS}__single`], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.NAME], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.TEXT_ASSERTION], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.LOCATIONS], (0, _field_config.FIELD)(readOnly)[`${_types.ConfigKey.SCHEDULE}.number`], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.ENABLED], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.MAX_ATTEMPTS], (0, _field_config.FIELD)(readOnly)[_constants.AlertConfigKey.STATUS_ENABLED]],
    advanced: [{
      ...DEFAULT_DATA_OPTIONS(readOnly),
      components: [(0, _field_config.FIELD)(readOnly)[_types.ConfigKey.TAGS], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.APM_SERVICE_NAME], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.SCREENSHOTS], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.NAMESPACE]]
    }, ...BROWSER_ADVANCED(readOnly)]
  },
  [_types.FormMonitorType.ICMP]: {
    step1: [(0, _field_config.FIELD)(readOnly)[_types.ConfigKey.FORM_MONITOR_TYPE]],
    step2: [(0, _field_config.FIELD)(readOnly)[`${_types.ConfigKey.HOSTS}__icmp`], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.NAME], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.LOCATIONS], (0, _field_config.FIELD)(readOnly)[`${_types.ConfigKey.SCHEDULE}.number`], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.WAIT], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.TIMEOUT], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.ENABLED], (0, _field_config.FIELD)(readOnly)[_types.ConfigKey.MAX_ATTEMPTS], (0, _field_config.FIELD)(readOnly)[_constants.AlertConfigKey.STATUS_ENABLED]],
    advanced: [DEFAULT_DATA_OPTIONS(readOnly), ICMP_ADVANCED(readOnly).requestConfig]
  }
});
exports.FORM_CONFIG = FORM_CONFIG;