"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.filterContentType = exports.contentTypes = exports.HeaderField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _types = require("../types");
var _key_value_field = require("./key_value_field");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HeaderField = ({
  contentMode,
  defaultValue,
  onChange,
  onBlur,
  'data-test-subj': dataTestSubj,
  readOnly
}) => {
  const defaultValueKeys = Object.keys(defaultValue).filter(filterContentType(defaultValue, contentTypes, contentMode));
  const formattedDefaultValues = [...defaultValueKeys.map(key => {
    return [key || '', defaultValue[key] || '']; // key, value
  })];

  const [headers, setHeaders] = (0, _react.useState)(formattedDefaultValues);
  (0, _react.useEffect)(() => {
    const formattedHeaders = headers.reduce((acc, header) => {
      const [key, value] = header;
      if (key) {
        return {
          ...acc,
          [key]: value
        };
      }
      return acc;
    }, {});
    if (contentMode) {
      onChange({
        'Content-Type': contentTypes[contentMode],
        ...formattedHeaders
      });
    } else {
      onChange(formattedHeaders);
    }
  }, [contentMode, headers, onChange]);
  return /*#__PURE__*/_react.default.createElement(_key_value_field.KeyValuePairsField, {
    addPairControlLabel: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.createPackagePolicy.stepConfigure.headerField.addHeader.label",
      defaultMessage: "Add header"
    }),
    defaultPairs: headers,
    onChange: setHeaders,
    onBlur: () => onBlur === null || onBlur === void 0 ? void 0 : onBlur(),
    "data-test-subj": dataTestSubj,
    readOnly: readOnly
  });
};

// We apply default `Content-Type` headers automatically depending on the request body mime type
// We hide the default Content-Type headers from the user as an implementation detail
// However, If the user applies a custom `Content-Type` header, it should be shown
exports.HeaderField = HeaderField;
const filterContentType = (defaultValue, contentTypeMap, contentMode) => key => {
  return key !== 'Content-Type' || key === 'Content-Type' && contentMode && defaultValue[key] !== contentTypeMap[contentMode];
};
exports.filterContentType = filterContentType;
const contentTypes = {
  [_types.CodeEditorMode.JSON]: _types.ContentType.JSON,
  [_types.CodeEditorMode.PLAINTEXT]: _types.ContentType.TEXT,
  [_types.CodeEditorMode.XML]: _types.ContentType.XML,
  [_types.CodeEditorMode.FORM]: _types.ContentType.FORM
};
exports.contentTypes = contentTypes;