"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useErrorDetailsBreadcrumbs = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _use_selected_location = require("../../monitor_details/hooks/use_selected_location");
var _use_test_run_details_breadcrumbs = require("../../test_run_details/hooks/use_test_run_details_breadcrumbs");
var _use_selected_monitor = require("../../monitor_details/hooks/use_selected_monitor");
var _runtime_types = require("../../../../../../common/runtime_types");
var _plugin = require("../../../../../../common/constants/plugin");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useErrorDetailsBreadcrumbs = extraCrumbs => {
  var _kibana$services$appl, _kibana$services$appl2;
  const kibana = (0, _public.useKibana)();
  const appPath = (_kibana$services$appl = (_kibana$services$appl2 = kibana.services.application) === null || _kibana$services$appl2 === void 0 ? void 0 : _kibana$services$appl2.getUrlForApp(_plugin.PLUGIN.SYNTHETICS_PLUGIN_ID)) !== null && _kibana$services$appl !== void 0 ? _kibana$services$appl : '';
  const {
    monitor
  } = (0, _use_selected_monitor.useSelectedMonitor)();
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)();
  const errorsBreadcrumbs = [{
    text: ERRORS_CRUMB,
    href: `${appPath}/monitor/${monitor === null || monitor === void 0 ? void 0 : monitor[_runtime_types.ConfigKey.CONFIG_ID]}/errors?locationId=${selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.id}`
  }, ...(extraCrumbs !== null && extraCrumbs !== void 0 ? extraCrumbs : [])];
  (0, _use_test_run_details_breadcrumbs.useTestRunDetailsBreadcrumbs)(errorsBreadcrumbs);
};
exports.useErrorDetailsBreadcrumbs = useErrorDetailsBreadcrumbs;
const ERRORS_CRUMB = _i18n.i18n.translate('xpack.synthetics.monitorsPage.errors', {
  defaultMessage: 'Errors'
});