"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SinglePingResult = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _test_time_formats = require("../../../utils/monitor_test_result/test_time_formats");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SinglePingResult = ({
  ping,
  loading
}) => {
  var _ping$resolve, _ping$monitor$duratio, _ping$monitor, _ping$monitor$duratio2, _ping$resolve$rtt$us, _ping$resolve2, _ping$resolve2$rtt, _ping$url, _ping$http, _ping$http$response;
  const ip = !loading ? ping === null || ping === void 0 ? void 0 : (_ping$resolve = ping.resolve) === null || _ping$resolve === void 0 ? void 0 : _ping$resolve.ip : undefined;
  const durationUs = !loading ? (_ping$monitor$duratio = ping === null || ping === void 0 ? void 0 : (_ping$monitor = ping.monitor) === null || _ping$monitor === void 0 ? void 0 : (_ping$monitor$duratio2 = _ping$monitor.duration) === null || _ping$monitor$duratio2 === void 0 ? void 0 : _ping$monitor$duratio2.us) !== null && _ping$monitor$duratio !== void 0 ? _ping$monitor$duratio : NaN : NaN;
  const rtt = !loading ? (_ping$resolve$rtt$us = ping === null || ping === void 0 ? void 0 : (_ping$resolve2 = ping.resolve) === null || _ping$resolve2 === void 0 ? void 0 : (_ping$resolve2$rtt = _ping$resolve2.rtt) === null || _ping$resolve2$rtt === void 0 ? void 0 : _ping$resolve2$rtt.us) !== null && _ping$resolve$rtt$us !== void 0 ? _ping$resolve$rtt$us : NaN : NaN;
  const url = !loading ? ping === null || ping === void 0 ? void 0 : (_ping$url = ping.url) === null || _ping$url === void 0 ? void 0 : _ping$url.full : undefined;
  const responseStatus = !loading ? ping === null || ping === void 0 ? void 0 : (_ping$http = ping.http) === null || _ping$http === void 0 ? void 0 : (_ping$http$response = _ping$http.response) === null || _ping$http$response === void 0 ? void 0 : _ping$http$response.status_code : undefined;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column",
    compressed: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, "IP"), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, ip), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, DURATION_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, isNaN(durationUs) ? '' : (0, _test_time_formats.formatTestDuration)(durationUs)), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, "rtt"), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, isNaN(rtt) ? '' : (0, _test_time_formats.formatTestDuration)(rtt)), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, "URL"), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, url), responseStatus ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, "Response status"), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, responseStatus))) : null);
};
exports.SinglePingResult = SinglePingResult;
const DURATION_LABEL = _i18n.i18n.translate('xpack.synthetics.monitor.duration.label', {
  defaultMessage: 'Duration'
});