"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionMenuContent = ActionMenuContent;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/exploratory-view-plugin/public");
var _last_refreshed = require("../components/last_refreshed");
var _auto_refresh_button = require("../components/auto_refresh_button");
var _contexts = require("../../../contexts");
var _hooks = require("../../../hooks");
var _constants = require("../../../../../../common/constants");
var _url_params = require("../../../utils/url_params");
var _inspector_header_link = require("./inspector_header_link");
var _toggle_alert_flyout_button = require("../../alerts/toggle_alert_flyout_button");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ANALYZE_DATA = _i18n.i18n.translate('xpack.synthetics.analyzeDataButtonLabel', {
  defaultMessage: 'Explore data'
});
const ANALYZE_MESSAGE = _i18n.i18n.translate('xpack.synthetics.analyzeDataButtonLabel.message', {
  defaultMessage: 'Go to Explore Data, where you can select and filter result data in any dimension and look for the cause or impact of performance problems.'
});
function ActionMenuContent() {
  var _selectedMonitor$moni, _selectedMonitor$moni2, _selectedMonitor$moni3;
  const {
    basePath
  } = (0, _contexts.useSyntheticsSettingsContext)();
  const {
    observabilityAIAssistant: {
      ObservabilityAIAssistantActionMenuItem
    } = {}
  } = (0, _contexts.useSyntheticsStartPlugins)();
  const params = (0, _hooks.useGetUrlParams)();
  const {
    dateRangeStart,
    dateRangeEnd
  } = params;
  const history = (0, _reactRouterDom.useHistory)();
  const selectedMonitor = {
    monitor: {
      id: undefined,
      name: 'test'
    }
  }; /* useSelector(monitorStatusSelector) TODO: Implement state for monitor status */

  const detailRouteMatch = (0, _reactRouterDom.useRouteMatch)(_constants.MONITOR_ROUTE);
  const monitorId = selectedMonitor === null || selectedMonitor === void 0 ? void 0 : (_selectedMonitor$moni = selectedMonitor.monitor) === null || _selectedMonitor$moni === void 0 ? void 0 : _selectedMonitor$moni.id;
  const syntheticExploratoryViewLink = (0, _public.createExploratoryViewUrl)({
    reportType: 'kpi-over-time',
    allSeries: [{
      dataType: 'synthetics',
      seriesType: 'area',
      selectedMetricField: 'monitor.duration.us',
      time: {
        from: dateRangeStart,
        to: dateRangeEnd
      },
      breakdown: monitorId ? 'observer.geo.name' : 'monitor.type',
      reportDefinitions: {
        'monitor.name': selectedMonitor !== null && selectedMonitor !== void 0 && (_selectedMonitor$moni2 = selectedMonitor.monitor) !== null && _selectedMonitor$moni2 !== void 0 && _selectedMonitor$moni2.name && (detailRouteMatch === null || detailRouteMatch === void 0 ? void 0 : detailRouteMatch.isExact) === true ? [selectedMonitor === null || selectedMonitor === void 0 ? void 0 : (_selectedMonitor$moni3 = selectedMonitor.monitor) === null || _selectedMonitor$moni3 === void 0 ? void 0 : _selectedMonitor$moni3.name] : [],
        'url.full': ['ALL_VALUES']
      },
      name: monitorId ? `${monitorId}-response-duration` : 'All monitors response duration'
    }]
  }, basePath);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLinks, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_last_refreshed.LastRefreshed, null), /*#__PURE__*/_react.default.createElement(_auto_refresh_button.AutoRefreshButton, null), /*#__PURE__*/_react.default.createElement(_toggle_alert_flyout_button.ToggleAlertFlyoutButton, null), /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    "aria-label": _i18n.i18n.translate('xpack.synthetics.page_header.settingsLink.label', {
      defaultMessage: 'Navigate to the Uptime settings page'
    }),
    color: "text",
    "data-test-subj": "settings-page-link",
    href: history.createHref({
      pathname: _constants.SETTINGS_ROUTE,
      search: (0, _url_params.stringifyUrlParams)(params, true)
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.page_header.settingsLink",
    defaultMessage: "Settings"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: /*#__PURE__*/_react.default.createElement("p", null, ANALYZE_MESSAGE)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    "aria-label": _i18n.i18n.translate('xpack.synthetics.page_header.analyzeData.label', {
      defaultMessage: 'Navigate to the "Explore Data" view to visualize Synthetics/User data'
    }),
    href: syntheticExploratoryViewLink,
    color: "text",
    iconType: "visBarVerticalStacked",
    "data-test-subj": 'syntheticsExploreDataButton'
  }, ANALYZE_DATA)), /*#__PURE__*/_react.default.createElement(_inspector_header_link.InspectorHeaderLink, null), ObservabilityAIAssistantActionMenuItem && ObservabilityAIAssistantActionMenuItem ? /*#__PURE__*/_react.default.createElement(ObservabilityAIAssistantActionMenuItem, null) : null);
}