"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isValidKuery = exports.AlertQueryBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/unified-search-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _public3 = require("@kbn/observability-shared-plugin/public");
var _constants = require("../../../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isValidKuery = query => {
  if (query === '') {
    return true;
  }
  const listOfOperators = [':', '>=', '=>', '>', '<'];
  for (let i = 0; i < listOfOperators.length; i++) {
    const operator = listOfOperators[i];
    const qParts = query.trim().split(operator);
    if (query.includes(operator) && qParts.length > 1 && qParts[1]) {
      return true;
    }
  }
  return false;
};
exports.isValidKuery = isValidKuery;
const AlertQueryBar = ({
  query = '',
  onChange
}) => {
  const {
    services
  } = (0, _public2.useKibana)();
  const {
    appName,
    notifications,
    http,
    docLinks,
    uiSettings,
    data,
    dataViews,
    unifiedSearch,
    storage,
    usageCollection
  } = services;
  const [inputVal, setInputVal] = (0, _react.useState)(query);
  const {
    data: dataView
  } = (0, _public3.useFetcher)(async () => {
    return await dataViews.create({
      title: _constants.SYNTHETICS_INDEX_PATTERN
    });
  }, []);
  (0, _react.useEffect)(() => {
    onChange(query);
    setInputVal(query);
  }, [onChange, query]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    style: {
      flexBasis: 485
    }
  }, /*#__PURE__*/_react.default.createElement(_public.QueryStringInput, {
    indexPatterns: dataView ? [dataView] : [],
    iconType: "search",
    isClearable: true,
    onChange: queryN => {
      setInputVal(queryN === null || queryN === void 0 ? void 0 : queryN.query);
      if (isValidKuery(queryN === null || queryN === void 0 ? void 0 : queryN.query)) {
        // we want to submit when user clears or paste a complete kuery
        onChange(queryN.query);
      }
    },
    onSubmit: queryN => {
      if (queryN) onChange(queryN.query);
    },
    query: {
      query: inputVal,
      language: 'kuery'
    },
    dataTestSubj: "xpack.synthetics.alerts.monitorStatus.filterBar",
    autoSubmit: true,
    disableLanguageSwitcher: true,
    isInvalid: !!(inputVal && !query),
    placeholder: _i18n.i18n.translate('xpack.synthetics.alerts.searchPlaceholder.kql', {
      defaultMessage: 'Filter using kql syntax'
    }),
    appName: appName,
    deps: {
      unifiedSearch,
      data,
      dataViews,
      storage,
      notifications,
      http,
      docLinks,
      uiSettings,
      usageCollection
    }
  }));
};
exports.AlertQueryBar = AlertQueryBar;