"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TLS_CERTIFICATE = exports.SYNTHETICS_TLS_RULE = exports.SYNTHETICS_STATUS_RULE = exports.SYNTHETICS_RULE_TYPES_ALERT_CONTEXT = exports.SYNTHETICS_RULE_TYPES = exports.SYNTHETICS_ALERT_RULE_TYPES = exports.MONITOR_STATUS = exports.ACTION_GROUP_DEFINITIONS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MONITOR_STATUS = {
  id: 'xpack.synthetics.alerts.actionGroups.monitorStatus',
  name: _i18n.i18n.translate('xpack.synthetics.alertRules.actionGroups.monitorStatus', {
    defaultMessage: 'Synthetics monitor status'
  })
};
exports.MONITOR_STATUS = MONITOR_STATUS;
const TLS_CERTIFICATE = {
  id: 'xpack.synthetics.alerts.actionGroups.tls',
  name: _i18n.i18n.translate('xpack.synthetics.alertRules.actionGroups.tls', {
    defaultMessage: 'Synthetics TLS certificate'
  })
};
exports.TLS_CERTIFICATE = TLS_CERTIFICATE;
const ACTION_GROUP_DEFINITIONS = {
  MONITOR_STATUS,
  TLS_CERTIFICATE
};
exports.ACTION_GROUP_DEFINITIONS = ACTION_GROUP_DEFINITIONS;
const SYNTHETICS_STATUS_RULE = 'xpack.synthetics.alerts.monitorStatus';
exports.SYNTHETICS_STATUS_RULE = SYNTHETICS_STATUS_RULE;
const SYNTHETICS_TLS_RULE = 'xpack.synthetics.alerts.tls';
exports.SYNTHETICS_TLS_RULE = SYNTHETICS_TLS_RULE;
const SYNTHETICS_ALERT_RULE_TYPES = {
  MONITOR_STATUS: SYNTHETICS_STATUS_RULE,
  TLS: SYNTHETICS_TLS_RULE
};
exports.SYNTHETICS_ALERT_RULE_TYPES = SYNTHETICS_ALERT_RULE_TYPES;
const SYNTHETICS_RULE_TYPES = [SYNTHETICS_STATUS_RULE, SYNTHETICS_TLS_RULE];
exports.SYNTHETICS_RULE_TYPES = SYNTHETICS_RULE_TYPES;
const SYNTHETICS_RULE_TYPES_ALERT_CONTEXT = 'observability.uptime';
exports.SYNTHETICS_RULE_TYPES_ALERT_CONTEXT = SYNTHETICS_RULE_TYPES_ALERT_CONTEXT;