"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SentinelOneConnector = exports.API_PATH = exports.API_MAX_RESULTS = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _server = require("@kbn/actions-plugin/server");
var _schema = require("../../../common/sentinelone/schema");
var _constants = require("../../../common/sentinelone/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const API_MAX_RESULTS = 1000;
exports.API_MAX_RESULTS = API_MAX_RESULTS;
const API_PATH = '/web/api/v2.1';
exports.API_PATH = API_PATH;
class SentinelOneConnector extends _server.SubActionConnector {
  constructor(params) {
    super(params);
    (0, _defineProperty2.default)(this, "urls", void 0);
    this.urls = {
      isolateHost: `${this.config.url}${API_PATH}/agents/actions/disconnect`,
      releaseHost: `${this.config.url}${API_PATH}/agents/actions/connect`,
      remoteScripts: `${this.config.url}${API_PATH}/remote-scripts`,
      remoteScriptStatus: `${this.config.url}${API_PATH}/remote-scripts/status`,
      remoteScriptsExecute: `${this.config.url}${API_PATH}/remote-scripts/execute`,
      agents: `${this.config.url}${API_PATH}/agents`
    };
    this.registerSubActions();
  }
  registerSubActions() {
    this.registerSubAction({
      name: _constants.SUB_ACTION.GET_REMOTE_SCRIPTS,
      method: 'getRemoteScripts',
      schema: _schema.SentinelOneGetRemoteScriptsParamsSchema
    });
    this.registerSubAction({
      name: _constants.SUB_ACTION.GET_REMOTE_SCRIPT_STATUS,
      method: 'getRemoteScriptStatus',
      schema: _schema.SentinelOneGetRemoteScriptStatusParamsSchema
    });
    this.registerSubAction({
      name: _constants.SUB_ACTION.GET_AGENTS,
      method: 'getAgents',
      schema: _schema.SentinelOneGetAgentsParamsSchema
    });
    this.registerSubAction({
      name: _constants.SUB_ACTION.ISOLATE_HOST,
      method: 'isolateHost',
      schema: _schema.SentinelOneIsolateHostParamsSchema
    });
    this.registerSubAction({
      name: _constants.SUB_ACTION.RELEASE_HOST,
      method: 'releaseHost',
      schema: _schema.SentinelOneIsolateHostParamsSchema
    });
    this.registerSubAction({
      name: _constants.SUB_ACTION.KILL_PROCESS,
      method: 'killProcess',
      schema: _schema.SentinelOneKillProcessParamsSchema
    });
    this.registerSubAction({
      name: _constants.SUB_ACTION.EXECUTE_SCRIPT,
      method: 'executeScript',
      schema: _schema.SentinelOneExecuteScriptParamsSchema
    });
  }
  async executeScript(payload) {
    await this.sentinelOneApiRequest({
      url: this.urls.remoteScriptsExecute,
      method: 'post',
      data: {
        data: {
          outputDestination: 'SentinelCloud',
          ...payload.script
        },
        filter: {
          computerName: payload.computerName
        }
      },
      responseSchema: _schema.SentinelOneExecuteScriptResponseSchema
    });
  }
  async killProcess({
    alertIds,
    processName,
    ...payload
  }) {
    var _agentData$data$, _agentData$data$2;
    const agentData = await this.getAgents(payload);
    const agentId = (_agentData$data$ = agentData.data[0]) === null || _agentData$data$ === void 0 ? void 0 : _agentData$data$.id;
    if (!agentId) {
      throw new Error(`No agent found for filter ${JSON.stringify(payload)}`);
    }
    const terminateScriptResponse = await this.getRemoteScripts({
      query: 'terminate',
      osTypes: agentData === null || agentData === void 0 ? void 0 : (_agentData$data$2 = agentData.data[0]) === null || _agentData$data$2 === void 0 ? void 0 : _agentData$data$2.osType
    });
    if (!processName) {
      throw new Error('No process name provided');
    }
    await this.sentinelOneApiRequest({
      url: this.urls.remoteScriptsExecute,
      method: 'post',
      data: {
        data: {
          outputDestination: 'SentinelCloud',
          scriptId: terminateScriptResponse.data[0].id,
          scriptRuntimeTimeoutSeconds: terminateScriptResponse.data[0].scriptRuntimeTimeoutSeconds,
          taskDescription: terminateScriptResponse.data[0].scriptName,
          inputParams: `--terminate --processes ${processName}`
        },
        filter: {
          ids: agentId
        }
      },
      responseSchema: _schema.SentinelOneKillProcessResponseSchema
    });
  }
  async isolateHost({
    alertIds,
    ...payload
  }) {
    const response = await this.getAgents(payload);
    if (response.data.length === 0) {
      const errorMessage = 'No agents found';
      throw new Error(errorMessage);
    }
    if (response.data[0].networkStatus === 'disconnected') {
      const errorMessage = 'Agent already isolated';
      throw new Error(errorMessage);
    }
    const agentId = response.data[0].id;
    return this.sentinelOneApiRequest({
      url: this.urls.isolateHost,
      method: 'post',
      data: {
        filter: {
          ids: agentId
        }
      },
      responseSchema: _schema.SentinelOneIsolateHostResponseSchema
    });
  }
  async releaseHost({
    alertIds,
    ...payload
  }) {
    const response = await this.getAgents(payload);
    if (response.data.length === 0) {
      throw new Error('No agents found');
    }
    if (response.data[0].networkStatus !== 'disconnected') {
      throw new Error('Agent not isolated');
    }
    const agentId = response.data[0].id;
    return this.sentinelOneApiRequest({
      url: this.urls.releaseHost,
      method: 'post',
      data: {
        filter: {
          ids: agentId
        }
      },
      responseSchema: _schema.SentinelOneIsolateHostResponseSchema
    });
  }
  async getAgents(payload) {
    return this.sentinelOneApiRequest({
      url: this.urls.agents,
      params: {
        ...payload
      },
      responseSchema: _schema.SentinelOneGetAgentsResponseSchema
    });
  }
  async getRemoteScriptStatus(payload) {
    return this.sentinelOneApiRequest({
      url: this.urls.remoteScriptStatus,
      params: {
        parent_task_id: payload.parentTaskId
      },
      responseSchema: _schema.SentinelOneGetRemoteScriptStatusResponseSchema
    });
  }
  async sentinelOneApiRequest(req) {
    const response = await this.request({
      ...req,
      params: {
        ...req.params,
        APIToken: this.secrets.token
      }
    });
    return response.data;
  }
  getResponseErrorMessage(error) {
    var _error$response, _error$response2;
    if (!((_error$response = error.response) !== null && _error$response !== void 0 && _error$response.status)) {
      return 'Unknown API Error';
    }
    if (error.response.status === 401) {
      return 'Unauthorized API Error';
    }
    return `API Error: ${(_error$response2 = error.response) === null || _error$response2 === void 0 ? void 0 : _error$response2.statusText}`;
  }
  async getRemoteScripts(payload) {
    return this.sentinelOneApiRequest({
      url: this.urls.remoteScripts,
      params: {
        limit: API_MAX_RESULTS,
        ...payload
      },
      responseSchema: _schema.SentinelOneGetRemoteScriptsResponseSchema
    });
  }
}
exports.SentinelOneConnector = SentinelOneConnector;