"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _constants = require("../../../common/sentinelone/constants");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SentinelOneParamsFields = ({
  actionConnector,
  actionParams,
  editAction,
  index,
  executionMode,
  errors,
  ...rest
}) => {
  var _errors$script, _subActionParams$scri, _subActionParams$scri2;
  const {
    toasts
  } = (0, _public.useKibana)().notifications;
  const {
    subAction,
    subActionParams
  } = actionParams;
  const [selectedScript, setSelectedScript] = (0, _react.useState)();
  const [selectedAgent, setSelectedAgent] = (0, _react.useState)(() => {
    if (subActionParams !== null && subActionParams !== void 0 && subActionParams.computerName) {
      return [{
        label: subActionParams === null || subActionParams === void 0 ? void 0 : subActionParams.computerName
      }];
    }
    return [];
  });
  const [connectorId] = (0, _react.useState)(actionConnector === null || actionConnector === void 0 ? void 0 : actionConnector.id);
  const isTest = (0, _react.useMemo)(() => executionMode === _public.ActionConnectorMode.Test, [executionMode]);
  const editSubActionParams = (0, _react.useCallback)(params => {
    editAction('subActionParams', {
      ...subActionParams,
      ...params
    }, index);
  }, [editAction, index, subActionParams]);
  const {
    response: {
      data: agents
    } = {},
    isLoading: isLoadingAgents,
    error: agentsError
  } = (0, _public.useSubAction)({
    connectorId,
    subAction: _constants.SUB_ACTION.GET_AGENTS,
    disabled: !isTest
  });
  const agentOptions = (0, _react.useMemo)(() => (0, _lodash.reduce)(agents, (acc, item) => {
    acc.push({
      label: item.computerName
    });
    return acc;
  }, []), [agents]);
  const {
    response: {
      data: remoteScripts
    } = {},
    isLoading: isLoadingScripts,
    error: scriptsError
  } = (0, _public.useSubAction)({
    connectorId,
    subAction: _constants.SUB_ACTION.GET_REMOTE_SCRIPTS
  });
  (0, _react.useEffect)(() => {
    if (agentsError) {
      toasts.danger({
        title: i18n.AGENTS_ERROR,
        body: agentsError.message
      });
    }
    if (scriptsError) {
      toasts.danger({
        title: i18n.REMOTE_SCRIPTS_ERROR,
        body: scriptsError.message
      });
    }
  }, [toasts, scriptsError, agentsError]);
  const pagination = {
    initialPageSize: 10,
    pageSizeOptions: [10, 20, 50]
  };
  const search = {
    defaultQuery: 'scriptType:action',
    box: {
      incremental: true
    },
    filters: [{
      type: 'field_value_selection',
      field: 'scriptType',
      name: i18n.SCRIPT_TYPE_FILTER_LABEL,
      multiSelect: true,
      options: [{
        value: 'action'
      }, {
        value: 'dataCollection'
      }]
    }, {
      type: 'field_value_selection',
      field: 'osTypes',
      name: i18n.OS_TYPES_FILTER_LABEL,
      multiSelect: true,
      options: [{
        value: 'Windows'
      }, {
        value: 'macos'
      }, {
        value: 'linux'
      }]
    }]
  };
  const [itemIdToExpandedRowMap, setItemIdToExpandedRowMap] = (0, _react.useState)({});
  const toggleDetails = script => {
    const itemIdToExpandedRowMapValues = {
      ...itemIdToExpandedRowMap
    };
    if (script.id) {
      if (itemIdToExpandedRowMapValues[script.id]) {
        delete itemIdToExpandedRowMapValues[script.id];
      } else {
        itemIdToExpandedRowMapValues[script.id] = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "More details true");
      }
    }
    setItemIdToExpandedRowMap(itemIdToExpandedRowMapValues);
  };
  const columns = [{
    field: 'scriptName',
    name: 'Script name'
  }, {
    field: 'scriptType',
    name: 'Script type'
  }, {
    field: 'osTypes',
    name: 'OS types'
  }, {
    actions: [{
      name: 'Choose',
      description: 'Choose this script',
      isPrimary: true,
      onClick: item => {
        var _item$requiresApprova;
        setSelectedScript(item);
        editSubActionParams({
          script: {
            scriptId: item.id,
            scriptRuntimeTimeoutSeconds: 3600,
            taskDescription: item.scriptName,
            requiresApproval: (_item$requiresApprova = item.requiresApproval) !== null && _item$requiresApprova !== void 0 ? _item$requiresApprova : false
          }
        });
      }
    }]
  }, {
    align: 'right',
    width: '40px',
    isExpander: true,
    render: script => {
      const itemIdToExpandedRowMapValues = {
        ...itemIdToExpandedRowMap
      };
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        onClick: () => toggleDetails(script),
        "aria-label": itemIdToExpandedRowMapValues[script.id] ? 'Collapse' : 'Expand',
        iconType: itemIdToExpandedRowMapValues[script.id] ? 'arrowDown' : 'arrowRight'
      });
    }
  }];
  const actionTypeOptions = [{
    value: _constants.SUB_ACTION.KILL_PROCESS,
    inputDisplay: i18n.KILL_PROCESS_ACTION_LABEL
  }, {
    value: _constants.SUB_ACTION.ISOLATE_HOST,
    inputDisplay: i18n.ISOLATE_AGENT_ACTION_LABEL
  }, {
    value: _constants.SUB_ACTION.RELEASE_HOST,
    inputDisplay: i18n.RELEASE_AGENT_ACTION_LABEL
  }];
  const handleEditSubAction = (0, _react.useCallback)(payload => {
    if (subAction !== payload) {
      editSubActionParams({});
      editAction('subAction', payload, index);
    }
  }, [editAction, editSubActionParams, index, subAction]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, isTest && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.AGENTS_FIELD_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    placeholder: i18n.AGENTS_FIELD_PLACEHOLDER,
    singleSelection: {
      asPlainText: true
    },
    options: agentOptions,
    selectedOptions: selectedAgent,
    onChange: item => {
      setSelectedAgent(item);
      editSubActionParams({
        computerName: item[0].label
      });
    },
    isDisabled: isLoadingAgents
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.ACTION_TYPE_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    fullWidth: true,
    options: actionTypeOptions,
    valueOfSelected: subAction,
    onChange: handleEditSubAction
  }))), subAction === _constants.SUB_ACTION.EXECUTE_SCRIPT && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: errors.script,
    isInvalid: !!((_errors$script = errors.script) !== null && _errors$script !== void 0 && _errors$script.length),
    label: 'Script',
    labelAppend: selectedScript ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => setSelectedScript(undefined)
    }, i18n.CHANGE_ACTION_LABEL) : null
  }, selectedScript !== null && selectedScript !== void 0 && selectedScript.scriptName ? /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    value: selectedScript.scriptName
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: remoteScripts !== null && remoteScripts !== void 0 ? remoteScripts : [],
    itemId: "scriptId",
    loading: isLoadingScripts,
    columns: columns,
    search: search,
    pagination: pagination,
    sorting: true,
    hasActions: true,
    itemIdToExpandedRowMap: itemIdToExpandedRowMap
  }))), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, selectedScript && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_public.TextAreaWithMessageVariables, {
    index: index,
    editAction: editAction,
    messageVariables: [],
    paramsProperty: 'subActionParams.script.inputParams',
    label: i18n.COMMAND_LABEL,
    inputTargetValue: (_subActionParams$scri = subActionParams === null || subActionParams === void 0 ? void 0 : (_subActionParams$scri2 = subActionParams.script) === null || _subActionParams$scri2 === void 0 ? void 0 : _subActionParams$scri2.inputParams) !== null && _subActionParams$scri !== void 0 ? _subActionParams$scri : undefined,
    helpText: selectedScript !== null && selectedScript !== void 0 && selectedScript.inputExample ? `Example: ${selectedScript === null || selectedScript === void 0 ? void 0 : selectedScript.inputExample}` : undefined
  })))));
};

// eslint-disable-next-line import/no-default-export
exports.default = SentinelOneParamsFields;
module.exports = exports.default;