"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _links_list = require("./links_list");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PagerDutyParamsFields = ({
  actionParams,
  editAction,
  index,
  messageVariables,
  errors
}) => {
  var _errors$summary;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    eventAction,
    dedupKey,
    summary,
    source,
    severity,
    timestamp,
    component,
    group,
    customDetails,
    links
  } = actionParams;
  const severityOptions = [{
    value: 'critical',
    text: _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.severitySelectCriticalOptionLabel', {
      defaultMessage: 'Critical'
    })
  }, {
    value: 'error',
    text: _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.severitySelectErrorOptionLabel', {
      defaultMessage: 'Error'
    })
  }, {
    value: 'warning',
    text: _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.severitySelectWarningOptionLabel', {
      defaultMessage: 'Warning'
    })
  }, {
    value: 'info',
    text: _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.severitySelectInfoOptionLabel', {
      defaultMessage: 'Info'
    })
  }];
  const eventActionOptions = [{
    value: 'trigger',
    text: _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.eventSelectTriggerOptionLabel', {
      defaultMessage: 'Trigger'
    })
  }, {
    value: 'resolve',
    text: _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.eventSelectResolveOptionLabel', {
      defaultMessage: 'Resolve'
    })
  }, {
    value: 'acknowledge',
    text: _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.eventSelectAcknowledgeOptionLabel', {
      defaultMessage: 'Acknowledge'
    })
  }];
  const isDedupeKeyRequired = eventAction !== 'trigger';
  const isTriggerPagerDutyEvent = eventAction === 'trigger';
  const isDedupKeyInvalid = errors.dedupKey !== undefined && errors.dedupKey.length > 0;
  const isSummaryInvalid = errors.summary !== undefined && errors.summary.length > 0 && summary !== undefined;
  const isTimestampInvalid = errors.timestamp !== undefined && errors.timestamp.length > 0 && timestamp !== undefined;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.eventActionSelectFieldLabel', {
      defaultMessage: 'Event action'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    "data-test-subj": "eventActionSelect",
    options: eventActionOptions,
    hasNoInitialSelection: (0, _lodash.isUndefined)(eventAction),
    value: eventAction,
    onChange: e => {
      editAction('eventAction', e.target.value, index);
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: {
      marginTop: euiTheme.size.s
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: errors.dedupKey,
    isInvalid: isDedupKeyInvalid,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.dedupKeyTextFieldLabel', {
      defaultMessage: 'DedupKey'
    }),
    labelAppend: isDedupeKeyRequired ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, _translations.OPTIONAL_LABEL)
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: editAction,
    messageVariables: messageVariables,
    paramsProperty: 'dedupKey',
    inputTargetValue: dedupKey
  })))), isTriggerPagerDutyEvent && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "pagerDutySummary",
    fullWidth: true,
    error: errors.summary,
    isInvalid: isSummaryInvalid,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.summaryFieldLabel', {
      defaultMessage: 'Summary'
    })
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: editAction,
    messageVariables: messageVariables,
    paramsProperty: 'summary',
    inputTargetValue: summary,
    errors: (_errors$summary = errors.summary) !== null && _errors$summary !== void 0 ? _errors$summary : []
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.severitySelectFieldLabel', {
      defaultMessage: 'Severity'
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, _translations.OPTIONAL_LABEL)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    "data-test-subj": "severitySelect",
    options: severityOptions,
    hasNoInitialSelection: (0, _lodash.isUndefined)(severity),
    value: severity,
    onChange: e => {
      editAction('severity', e.target.value, index);
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: errors.timestamp,
    isInvalid: isTimestampInvalid,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.timestampTextFieldLabel', {
      defaultMessage: 'Timestamp'
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, _translations.OPTIONAL_LABEL)
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: editAction,
    messageVariables: messageVariables,
    paramsProperty: 'timestamp',
    inputTargetValue: timestamp,
    errors: errors.timestamp
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.componentTextFieldLabel', {
      defaultMessage: 'Component'
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, _translations.OPTIONAL_LABEL)
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: editAction,
    messageVariables: messageVariables,
    paramsProperty: 'component',
    inputTargetValue: component
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.groupTextFieldLabel', {
      defaultMessage: 'Group'
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, _translations.OPTIONAL_LABEL)
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: editAction,
    messageVariables: messageVariables,
    paramsProperty: 'group',
    inputTargetValue: group
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.sourceTextFieldLabel', {
      defaultMessage: 'Source'
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, _translations.OPTIONAL_LABEL)
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: editAction,
    messageVariables: messageVariables,
    paramsProperty: 'source',
    inputTargetValue: source
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "pagerDutyClass",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.classFieldLabel', {
      defaultMessage: 'Class'
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, _translations.OPTIONAL_LABEL)
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: editAction,
    messageVariables: messageVariables,
    paramsProperty: 'class',
    inputTargetValue: actionParams.class
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "pagerDutyCustomDetails",
    fullWidth: true,
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, _translations.OPTIONAL_LABEL)
  }, /*#__PURE__*/_react.default.createElement(_public.JsonEditorWithMessageVariables, {
    messageVariables: messageVariables,
    paramsProperty: 'customDetails',
    inputTargetValue: customDetails,
    errors: errors.customDetails,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.pagerDuty.customDetailsFieldLabel', {
      defaultMessage: 'Custom details'
    }),
    onDocumentsChange: json => {
      editAction('customDetails', json, index);
    },
    onBlur: () => {
      if (!customDetails) {
        editAction('customDetails', '{}', index);
      }
    },
    "data-test-subj": "customDetailsJsonEditor"
  })), /*#__PURE__*/_react.default.createElement(_links_list.LinksList, {
    editAction: editAction,
    errors: errors,
    index: index,
    links: links,
    messageVariables: messageVariables
  })));
};

// eslint-disable-next-line import/no-default-export
exports.default = PagerDutyParamsFields;
module.exports = exports.default;