"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateAlert = void 0;
Object.defineProperty(exports, "isPartialCreateAlertSchema", {
  enumerable: true,
  get: function () {
    return _schema.isPartialCreateAlertSchema;
  }
});
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _display_more_options = require("../display_more_options");
var _additional_options = require("./additional_options");
var _tags = require("./tags");
var _priority = require("./priority");
var _schema = require("./schema");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const JsonEditorLazy = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./json_editor'))));
const FormView = ({
  editSubAction,
  editOptionalSubAction,
  errors,
  index,
  messageVariables,
  subActionParams,
  showSaveError,
  executionMode
}) => {
  var _subActionParams$tags;
  const isMessageInvalid = errors['subActionParams.message'] !== undefined && errors['subActionParams.message'].length > 0 && (subActionParams === null || subActionParams === void 0 ? void 0 : subActionParams.message) !== undefined || showSaveError;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "opsgenie-message-row",
    fullWidth: true,
    error: errors['subActionParams.message'],
    label: i18n.MESSAGE_FIELD_LABEL,
    isInvalid: isMessageInvalid,
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, i18n.REQUIRED_LABEL)
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: editSubAction,
    messageVariables: messageVariables,
    paramsProperty: 'message',
    inputTargetValue: subActionParams === null || subActionParams === void 0 ? void 0 : subActionParams.message,
    errors: errors['subActionParams.message']
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_tags.Tags, {
    values: (_subActionParams$tags = subActionParams === null || subActionParams === void 0 ? void 0 : subActionParams.tags) !== null && _subActionParams$tags !== void 0 ? _subActionParams$tags : [],
    onChange: editOptionalSubAction,
    executionMode: executionMode
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_priority.Priority, {
    priority: subActionParams === null || subActionParams === void 0 ? void 0 : subActionParams.priority,
    onChange: editOptionalSubAction
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm'
  }), /*#__PURE__*/_react.default.createElement(_public.TextAreaWithMessageVariables, {
    index: index,
    editAction: editOptionalSubAction,
    messageVariables: messageVariables,
    paramsProperty: 'description',
    inputTargetValue: subActionParams === null || subActionParams === void 0 ? void 0 : subActionParams.description,
    label: i18n.DESCRIPTION_FIELD_LABEL
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "opsgenie-alias-row",
    fullWidth: true,
    label: i18n.ALIAS_FIELD_LABEL,
    helpText: i18n.OPSGENIE_ALIAS_HELP
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: editOptionalSubAction,
    messageVariables: messageVariables,
    paramsProperty: 'alias',
    inputTargetValue: subActionParams === null || subActionParams === void 0 ? void 0 : subActionParams.alias
  })));
};
FormView.displayName = 'FormView';
const CreateAlertComponent = ({
  editSubAction,
  editAction,
  editOptionalSubAction,
  errors,
  index,
  messageVariables,
  subActionParams,
  showSaveError,
  executionMode
}) => {
  const [showingMoreOptions, setShowingMoreOptions] = (0, _react.useState)(false);
  const [showJsonEditor, setShowJsonEditor] = (0, _react.useState)(false);
  const toggleShowJsonEditor = (0, _react.useCallback)(event => {
    if (!event.target.checked) {
      // when the user switches back remove the json editor error if there was one
      // must mark as undefined to remove the field so it is not sent to the server side
      editAction('jsonEditorError', undefined, index);
    }
    setShowJsonEditor(event.target.checked);
  }, [editAction, index]);
  const toggleShowingMoreOptions = (0, _react.useCallback)(() => setShowingMoreOptions(previousState => !previousState), []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: i18n.USE_JSON_EDITOR_LABEL,
    checked: showJsonEditor,
    onChange: toggleShowJsonEditor,
    "data-test-subj": "opsgenie-show-json-editor-toggle"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm'
  }), showJsonEditor ? /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_public.SectionLoading, null, i18n.LOADING_JSON_EDITOR)
  }, /*#__PURE__*/_react.default.createElement(JsonEditorLazy, {
    editAction: editAction,
    index: index,
    messageVariables: messageVariables,
    subActionParams: subActionParams
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FormView, {
    editOptionalSubAction: editOptionalSubAction,
    editSubAction: editSubAction,
    errors: errors,
    index: index,
    messageVariables: messageVariables,
    subActionParams: subActionParams,
    showSaveError: showSaveError
  }), showingMoreOptions ? /*#__PURE__*/_react.default.createElement(_additional_options.AdditionalOptions, {
    subActionParams: subActionParams,
    editOptionalSubAction: editOptionalSubAction,
    messageVariables: messageVariables,
    index: index
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm'
  }), /*#__PURE__*/_react.default.createElement(_display_more_options.DisplayMoreOptions, {
    showingMoreOptions: showingMoreOptions,
    toggleShowingMoreOptions: toggleShowingMoreOptions
  })));
};
CreateAlertComponent.displayName = 'CreateAlert';
const CreateAlert = /*#__PURE__*/_react.default.memo(CreateAlertComponent);
exports.CreateAlert = CreateAlert;