"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdditionalOptions = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AdditionalOptionsComponent = ({
  subActionParams,
  editOptionalSubAction,
  messageVariables,
  index
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "opsgenie-entity-row",
    fullWidth: true,
    label: i18n.ENTITY_FIELD_LABEL,
    helpText: i18n.OPSGENIE_ENTITY_HELP
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: editOptionalSubAction,
    messageVariables: messageVariables,
    paramsProperty: 'entity',
    inputTargetValue: subActionParams === null || subActionParams === void 0 ? void 0 : subActionParams.entity
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "opsgenie-source-row",
    fullWidth: true,
    label: i18n.SOURCE_FIELD_LABEL,
    helpText: i18n.OPSGENIE_SOURCE_HELP
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: editOptionalSubAction,
    messageVariables: messageVariables,
    paramsProperty: 'source',
    inputTargetValue: subActionParams === null || subActionParams === void 0 ? void 0 : subActionParams.source
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "opsgenie-user-row",
    fullWidth: true,
    label: i18n.USER_FIELD_LABEL,
    helpText: i18n.OPSGENIE_USER_HELP
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: editOptionalSubAction,
    messageVariables: messageVariables,
    paramsProperty: 'user',
    inputTargetValue: subActionParams === null || subActionParams === void 0 ? void 0 : subActionParams.user
  })), /*#__PURE__*/_react.default.createElement(_public.TextAreaWithMessageVariables, {
    index: index,
    editAction: editOptionalSubAction,
    messageVariables: messageVariables,
    paramsProperty: 'note',
    inputTargetValue: subActionParams === null || subActionParams === void 0 ? void 0 : subActionParams.note,
    label: i18n.NOTE_FIELD_LABEL
  }));
};
AdditionalOptionsComponent.displayName = 'AdditionalOptions';
const AdditionalOptions = /*#__PURE__*/_react.default.memo(AdditionalOptionsComponent);
exports.AdditionalOptions = AdditionalOptions;