"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isRESTApiError = exports.isFieldInvalid = exports.getSelectedConnectorIcon = exports.getConnectorDescriptiveTitle = exports.choicesToEuiOptions = exports.DEFAULT_CORRELATION_ID = exports.ACTION_GROUP_RECOVERED = void 0;
var _react = require("react");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const DEFAULT_CORRELATION_ID = '{{rule.id}}:{{alert.id}}';
exports.DEFAULT_CORRELATION_ID = DEFAULT_CORRELATION_ID;
const ACTION_GROUP_RECOVERED = 'recovered';
exports.ACTION_GROUP_RECOVERED = ACTION_GROUP_RECOVERED;
const choicesToEuiOptions = choices => choices.map(choice => ({
  value: choice.value,
  text: choice.label
}));
exports.choicesToEuiOptions = choicesToEuiOptions;
const isRESTApiError = res => res != null && (res.error != null || res.status === 'failure');
exports.isRESTApiError = isRESTApiError;
const isFieldInvalid = (field, error) => error !== undefined && error.length > 0 && field !== undefined;
exports.isFieldInvalid = isFieldInvalid;
const getConnectorDescriptiveTitle = connector => {
  let title = connector.name;
  if (connector.isDeprecated) {
    title += ` ${_public.deprecatedMessage}`;
  }
  return title;
};
exports.getConnectorDescriptiveTitle = getConnectorDescriptiveTitle;
const getSelectedConnectorIcon = actionConnector => {
  if (actionConnector.isDeprecated) {
    return /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./selection_row'))));
  }
};
exports.getSelectedConnectorIcon = getSelectedConnectorIcon;