"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.EmailActionConnectorFields = void 0;
exports.nullableString = nullableString;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/actions-plugin/common");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _common2 = require("../../../common");
var _email = require("./email");
var _use_email_config = require("./use_email_config");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const {
  emptyField
} = _helpers.fieldValidators;
const ExchangeFormFields = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./exchange_form'))));
const shouldDisableEmailConfiguration = service => (0, _lodash.isEmpty)(service) || service !== _common2.AdditionalEmailServices.EXCHANGE && service !== _common2.AdditionalEmailServices.OTHER;
const getEmailConfig = (href, validateFunc) => ({
  label: i18n.FROM_LABEL,
  helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: href,
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackConnectors.components.email.configureAccountsHelpLabel",
    defaultMessage: "Configure email accounts"
  })),
  validations: [{
    validator: emptyField(i18n.SENDER_REQUIRED)
  }, {
    validator: ({
      value
    }) => {
      const validatedEmail = validateFunc([value])[0];
      if (!validatedEmail.valid) {
        const message = validatedEmail.reason === _common.InvalidEmailReason.notAllowed ? i18n.getNotAllowedEmailAddress(value) : i18n.getInvalidEmailAddress(value);
        return {
          message
        };
      }
    }
  }]
});
const portConfig = {
  label: i18n.PORT_LABEL,
  validations: [{
    validator: emptyField(i18n.PORT_REQUIRED)
  }, {
    validator: ({
      value
    }) => {
      const port = Number.parseFloat(value);
      if (!Number.isInteger(port)) {
        return {
          message: i18n.PORT_INVALID
        };
      }
    }
  }]
};
const EmailActionConnectorFields = ({
  readOnly
}) => {
  const {
    docLinks,
    http,
    isCloud,
    notifications: {
      toasts
    }
  } = (0, _public.useKibana)().services;
  const {
    services: {
      validateEmailAddresses
    }
  } = (0, _public.useConnectorContext)();
  const form = (0, _hook_form_lib.useFormContext)();
  const {
    updateFieldValues
  } = form;
  const [{
    config
  }] = (0, _hook_form_lib.useFormData)({
    watch: ['config.service', 'config.hasAuth']
  });
  const emailFieldConfig = (0, _react.useMemo)(() => getEmailConfig(docLinks.links.alerting.emailActionConfig, validateEmailAddresses), [docLinks.links.alerting.emailActionConfig, validateEmailAddresses]);
  const {
    service = null,
    hasAuth = false
  } = config !== null && config !== void 0 ? config : {};
  const disableServiceConfig = shouldDisableEmailConfiguration(service);
  const {
    isLoading,
    getEmailServiceConfig
  } = (0, _use_email_config.useEmailConfig)({
    http,
    toasts
  });
  (0, _react.useEffect)(() => {
    async function fetchConfig() {
      if (service === null || service === _common2.AdditionalEmailServices.OTHER || service === _common2.AdditionalEmailServices.EXCHANGE) {
        return;
      }
      const emailConfig = await getEmailServiceConfig(service);
      updateFieldValues({
        config: {
          host: emailConfig === null || emailConfig === void 0 ? void 0 : emailConfig.host,
          port: emailConfig === null || emailConfig === void 0 ? void 0 : emailConfig.port,
          secure: emailConfig === null || emailConfig === void 0 ? void 0 : emailConfig.secure
        }
      });
    }
    fetchConfig();
  }, [updateFieldValues, getEmailServiceConfig, service]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.from",
    component: _components.TextField,
    config: emailFieldConfig,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'emailFromInput',
        readOnly
      }
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.service",
    component: _components.SelectField,
    config: {
      label: i18n.SERVICE_LABEL,
      validations: [{
        validator: emptyField(i18n.SERVICE_REQUIRED)
      }]
    },
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'emailServiceSelectInput',
        options: (0, _email.getEmailServices)(isCloud),
        fullWidth: true,
        hasNoInitialSelection: true,
        disabled: readOnly || isLoading,
        isLoading,
        readOnly
      }
    }
  }))), service === _common2.AdditionalEmailServices.EXCHANGE ? /*#__PURE__*/_react.default.createElement(ExchangeFormFields, {
    readOnly: readOnly
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.host",
    component: _components.TextField,
    config: {
      label: i18n.HOST_LABEL,
      validations: [{
        validator: emptyField(i18n.HOST_REQUIRED)
      }]
    },
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'emailHostInput',
        readOnly,
        isLoading,
        disabled: disableServiceConfig
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.port",
    component: _components.NumericField,
    config: portConfig,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'emailPortInput',
        readOnly,
        isLoading,
        disabled: disableServiceConfig
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.secure",
    component: _components.ToggleField,
    config: {
      defaultValue: false
    },
    componentProps: {
      hasEmptyLabelSpace: true,
      euiFieldProps: {
        label: i18n.SECURE_LABEL,
        disabled: readOnly || disableServiceConfig,
        'data-test-subj': 'emailSecureSwitch',
        readOnly
      }
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackConnectors.components.email.authenticationLabel",
    defaultMessage: "Authentication"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.hasAuth",
    component: _components.ToggleField,
    config: {
      defaultValue: true
    },
    componentProps: {
      euiFieldProps: {
        label: i18n.HAS_AUTH_LABEL,
        disabled: readOnly,
        readOnly
      }
    }
  }))), hasAuth ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "secrets.user",
    component: _components.TextField,
    config: {
      label: i18n.USERNAME_LABEL,
      validations: [{
        validator: emptyField(i18n.USERNAME_REQUIRED)
      }]
    },
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'emailUserInput',
        readOnly
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "secrets.password",
    config: {
      label: i18n.PASSWORD_LABEL,
      validations: [{
        validator: emptyField(i18n.PASSWORD_REQUIRED)
      }]
    },
    component: _components.PasswordField,
    componentProps: {
      euiFieldProps: {
        readOnly,
        'data-test-subj': 'emailPasswordInput'
      }
    }
  })))) : null));
};

// if the string == null or is empty, return null, else return string
exports.default = exports.EmailActionConnectorFields = EmailActionConnectorFields;
function nullableString(str) {
  if (str == null || str.trim() === '') return null;
  return str;
}

// eslint-disable-next-line import/no-default-export