"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.severities = exports.SeverityFilter = exports.CaseSeverity = void 0;
var _uiTheme = require("@kbn/ui-theme");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let CaseSeverity;
exports.CaseSeverity = CaseSeverity;
(function (CaseSeverity) {
  CaseSeverity["LOW"] = "low";
  CaseSeverity["MEDIUM"] = "medium";
  CaseSeverity["HIGH"] = "high";
  CaseSeverity["CRITICAL"] = "critical";
})(CaseSeverity || (exports.CaseSeverity = CaseSeverity = {}));
const severities = {
  [CaseSeverity.LOW]: {
    color: _uiTheme.euiLightVars.euiColorVis0,
    label: i18n.SEVERITY_LOW_LABEL
  },
  [CaseSeverity.MEDIUM]: {
    color: _uiTheme.euiLightVars.euiColorVis5,
    label: i18n.SEVERITY_MEDIUM_LABEL
  },
  [CaseSeverity.HIGH]: {
    color: _uiTheme.euiLightVars.euiColorVis7,
    label: i18n.SEVERITY_HIGH_LABEL
  },
  [CaseSeverity.CRITICAL]: {
    color: _uiTheme.euiLightVars.euiColorVis9,
    label: i18n.SEVERITY_CRITICAL_LABEL
  }
};
exports.severities = severities;
const SeverityFilter = ({
  selectedSeverity,
  onSeverityChange
}) => {
  const caseSeverities = Object.keys(severities);
  const options = caseSeverities.map(severity => {
    const severityData = severities[severity];
    return {
      value: severity,
      inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        alignItems: 'center',
        responsive: false,
        "data-test-subj": `case-severity-selection-${severity}`
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        color: severityData.color
      }, severityData.label)))
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    fullWidth: true,
    options: options,
    valueOfSelected: selectedSeverity,
    onChange: onSeverityChange,
    "data-test-subj": "case-severity-selection"
  });
};
exports.SeverityFilter = SeverityFilter;
SeverityFilter.displayName = 'SeverityFilter';