"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.DashboardLink = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_get_dashboard = require("../lib/gen_ai/use_get_dashboard");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// tested from ./connector.test.tsx
const DashboardLink = ({
  connectorId,
  connectorName,
  selectedProvider = 'Bedrock'
}) => {
  const {
    dashboardUrl
  } = (0, _use_get_dashboard.useGetDashboard)({
    connectorId,
    selectedProvider
  });
  const {
    services: {
      application: {
        navigateToUrl
      }
    }
  } = (0, _public.useKibana)();
  const onClick = (0, _react.useCallback)(e => {
    e.preventDefault();
    if (dashboardUrl) {
      navigateToUrl(dashboardUrl);
    }
  }, [dashboardUrl, navigateToUrl]);
  return dashboardUrl != null ?
  /*#__PURE__*/
  // href gives us right click -> open in new tab
  // onclick prevents page reload
  // eslint-disable-next-line @elastic/eui/href-or-on-click
  _react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "link-gen-ai-token-dashboard",
    onClick: onClick,
    href: dashboardUrl
  }, i18n.USAGE_DASHBOARD_LINK(selectedProvider, connectorName)) : null;
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.DashboardLink = DashboardLink;