"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValidChannelIdSubActionParamsSchema = exports.ValidChannelIdParamsSchema = exports.SlackApiSecretsSchema = exports.SlackApiParamsSchema = exports.SlackApiConfigSchema = exports.PostMessageSubActionParamsSchema = exports.PostMessageParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SlackApiSecretsSchema = _configSchema.schema.object({
  token: _configSchema.schema.string({
    minLength: 1
  })
});
exports.SlackApiSecretsSchema = SlackApiSecretsSchema;
const SlackApiConfigSchema = _configSchema.schema.object({
  allowedChannels: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
    id: _configSchema.schema.string({
      minLength: 1
    }),
    name: _configSchema.schema.string({
      minLength: 1
    })
  }), {
    maxSize: 25
  }))
});
exports.SlackApiConfigSchema = SlackApiConfigSchema;
const ValidChannelIdSubActionParamsSchema = _configSchema.schema.object({
  channelId: _configSchema.schema.maybe(_configSchema.schema.string())
});
exports.ValidChannelIdSubActionParamsSchema = ValidChannelIdSubActionParamsSchema;
const ValidChannelIdParamsSchema = _configSchema.schema.object({
  subAction: _configSchema.schema.literal('validChannelId'),
  subActionParams: ValidChannelIdSubActionParamsSchema
});
exports.ValidChannelIdParamsSchema = ValidChannelIdParamsSchema;
const PostMessageSubActionParamsSchema = _configSchema.schema.object({
  channels: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string(), {
    maxSize: 1
  })),
  channelIds: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string(), {
    maxSize: 1
  })),
  text: _configSchema.schema.string({
    minLength: 1
  })
});
exports.PostMessageSubActionParamsSchema = PostMessageSubActionParamsSchema;
const PostMessageParamsSchema = _configSchema.schema.object({
  subAction: _configSchema.schema.literal('postMessage'),
  subActionParams: PostMessageSubActionParamsSchema
});
exports.PostMessageParamsSchema = PostMessageParamsSchema;
const SlackApiParamsSchema = _configSchema.schema.oneOf([ValidChannelIdParamsSchema, PostMessageParamsSchema]);
exports.SlackApiParamsSchema = SlackApiParamsSchema;