"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SUB_ACTION = exports.DEFAULT_TOKEN_LIMIT = exports.DEFAULT_BEDROCK_URL = exports.DEFAULT_BEDROCK_MODEL = exports.BEDROCK_TITLE = exports.BEDROCK_CONNECTOR_ID = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BEDROCK_TITLE = _i18n.i18n.translate('xpack.stackConnectors.components.bedrock.connectorTypeTitle', {
  defaultMessage: 'Amazon Bedrock'
});
exports.BEDROCK_TITLE = BEDROCK_TITLE;
const BEDROCK_CONNECTOR_ID = '.bedrock';
exports.BEDROCK_CONNECTOR_ID = BEDROCK_CONNECTOR_ID;
let SUB_ACTION;
exports.SUB_ACTION = SUB_ACTION;
(function (SUB_ACTION) {
  SUB_ACTION["RUN"] = "run";
  SUB_ACTION["INVOKE_AI"] = "invokeAI";
  SUB_ACTION["INVOKE_STREAM"] = "invokeStream";
  SUB_ACTION["DASHBOARD"] = "getDashboard";
  SUB_ACTION["TEST"] = "test";
})(SUB_ACTION || (exports.SUB_ACTION = SUB_ACTION = {}));
const DEFAULT_TOKEN_LIMIT = 8191;
exports.DEFAULT_TOKEN_LIMIT = DEFAULT_TOKEN_LIMIT;
const DEFAULT_BEDROCK_MODEL = 'anthropic.claude-v2';
exports.DEFAULT_BEDROCK_MODEL = DEFAULT_BEDROCK_MODEL;
const DEFAULT_BEDROCK_URL = `https://bedrock-runtime.us-east-1.amazonaws.com`;
exports.DEFAULT_BEDROCK_URL = DEFAULT_BEDROCK_URL;