"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryThresholdHelpPopover = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PopoverStyles = (0, _react2.css)`
  max-width: 400px;
`;
class QueryThresholdHelpPopover extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isPopoverOpen: false
    });
    (0, _defineProperty2.default)(this, "PopoverStyles", (0, _react2.css)`
    max-width: 400px;
  `);
    (0, _defineProperty2.default)(this, "_togglePopover", () => {
      this.setState(prevState => ({
        isPopoverOpen: !prevState.isPopoverOpen
      }));
    });
    (0, _defineProperty2.default)(this, "_closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
  }
  _renderContent() {
    return /*#__PURE__*/_react.default.createElement("div", {
      css: PopoverStyles
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      grow: false,
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.stackAlerts.esQuery.ui.thresholdHelp.threshold",
      defaultMessage: "Each time the rule runs, it checks whether the number of documents that match your query meets this threshold. If there is a grouped over clause, the rule checks the condition for the specified number of top groups."
    })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.stackAlerts.esQuery.ui.thresholdHelp.timeWindow",
      defaultMessage: "The time window indicates how far back in time to search. To avoid gaps in detection, set this value greater than or equal to the value you chose for the {checkField} field.",
      values: {
        checkField: /*#__PURE__*/_react.default.createElement("b", null, "Check every")
      }
    })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.stackAlerts.esQuery.ui.thresholdHelp.duplicateMatches",
      defaultMessage: "If {excludePrevious} is turned on, a document that matches the query in multiple runs will be used in only the first threshold calculation.",
      values: {
        excludePrevious: /*#__PURE__*/_react.default.createElement("b", null, "Exclude matches from previous runs")
      }
    }))));
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "thresholdHelpPopover",
      "data-test-subj": "thresholdHelpPopover",
      anchorPosition: "upLeft",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        onClick: this._togglePopover,
        iconType: "documentation",
        "aria-label": _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.thresholdHelp.ariaLabel', {
          defaultMessage: 'Help'
        })
      }),
      isOpen: this.state.isPopoverOpen,
      closePopover: this._closePopover,
      repositionOnScroll: true,
      ownFocus: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.stackAlerts.esQuery.ui.thresholdHelp.title",
      defaultMessage: "Set the group, threshold and time window"
    })), this._renderContent());
  }
}
exports.QueryThresholdHelpPopover = QueryThresholdHelpPopover;