"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsQueryRuleTypeExpression = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
require("brace/theme/github");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _search_source_expression = require("./search_source_expression");
var _es_query_expression = require("./es_query_expression");
var _query_form_type_chooser = require("./query_form_type_chooser");
var _util = require("../util");
var _constants = require("../constants");
var _esql_query_expression = require("./esql_query_expression");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function areSearchSourceExpressionPropsEqual(prevProps, nextProps) {
  const areErrorsEqual = (0, _fastDeepEqual.default)(prevProps.errors, nextProps.errors);
  const areRuleParamsEqual = (0, _fastDeepEqual.default)(prevProps.ruleParams, nextProps.ruleParams);
  return areErrorsEqual && areRuleParamsEqual;
}
const SearchSourceExpressionMemoized = /*#__PURE__*/(0, _react.memo)(_search_source_expression.SearchSourceExpression, areSearchSourceExpressionPropsEqual);
const EsQueryRuleTypeExpression = props => {
  var _props$metadata$isMan, _props$metadata;
  const {
    ruleParams,
    errors,
    setRuleProperty,
    setRuleParams
  } = props;
  const isSearchSource = (0, _util.isSearchSourceRule)(ruleParams);
  const isEsqlQuery = (0, _util.isEsqlQueryRule)(ruleParams);
  // metadata provided only when open alert from Discover page
  const isManagementPage = (_props$metadata$isMan = (_props$metadata = props.metadata) === null || _props$metadata === void 0 ? void 0 : _props$metadata.isManagementPage) !== null && _props$metadata$isMan !== void 0 ? _props$metadata$isMan : true;
  const formTypeSelected = (0, _react.useCallback)(searchType => {
    if (!searchType) {
      // @ts-expect-error Reset rule params regardless of their type
      setRuleProperty('params', {});
      return;
    }
    setRuleParams('searchType', searchType);
  }, [setRuleParams, setRuleProperty]);
  const expressionGenericErrorMessage = _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.alertParams.fixErrorInExpressionBelowValidationMessage', {
    defaultMessage: 'Expression contains errors.'
  });
  const errorParam = _constants.ALL_EXPRESSION_ERROR_KEYS.find(errorKey => {
    var _errors$errorKey;
    return ((_errors$errorKey = errors[errorKey]) === null || _errors$errorKey === void 0 ? void 0 : _errors$errorKey.length) >= 1 && ruleParams[errorKey] !== undefined;
  });
  const expressionError = !!errorParam && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    size: "s",
    "data-test-subj": "esQueryAlertExpressionError",
    title: ['index', 'searchType', 'timeField'].includes(errorParam) ? errors[errorParam] : expressionGenericErrorMessage
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, expressionError, isManagementPage && /*#__PURE__*/_react.default.createElement(_query_form_type_chooser.QueryFormTypeChooser, {
    searchType: ruleParams.searchType,
    onFormTypeSelect: formTypeSelected
  }), ruleParams.searchType && isSearchSource && /*#__PURE__*/_react.default.createElement(SearchSourceExpressionMemoized, (0, _extends2.default)({}, props, {
    ruleParams: ruleParams
  })), ruleParams.searchType && !isSearchSource && !isEsqlQuery && /*#__PURE__*/_react.default.createElement(_es_query_expression.EsQueryExpression, (0, _extends2.default)({}, props, {
    ruleParams: ruleParams
  })), ruleParams.searchType && isEsqlQuery && /*#__PURE__*/_react.default.createElement(_esql_query_expression.EsqlQueryExpression, (0, _extends2.default)({}, props, {
    ruleParams: ruleParams
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null));
};
exports.EsQueryRuleTypeExpression = EsQueryRuleTypeExpression;