"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsqlQueryExpression = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _public2 = require("@kbn/text-based-languages/public");
var _textBasedEditor = require("@kbn/text-based-editor");
var _esQuery = require("@kbn/es-query");
var _common = require("@kbn/alerting-plugin/common");
var _common2 = require("@kbn/triggers-actions-ui-plugin/public/common");
var _types = require("../types");
var _constants = require("../constants");
var _util = require("../util");
var _validation = require("../validation");
var _test_query_row = require("../test_query_row");
var _common3 = require("../../../../common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EsqlQueryExpression = ({
  ruleParams,
  setRuleParams,
  setRuleProperty,
  errors
}) => {
  const {
    expressions,
    http
  } = (0, _util.useTriggerUiActionServices)();
  const {
    esqlQuery,
    timeWindowSize,
    timeWindowUnit,
    timeField
  } = ruleParams;
  const [currentRuleParams, setCurrentRuleParams] = (0, _react.useState)({
    ...ruleParams,
    timeWindowSize: timeWindowSize !== null && timeWindowSize !== void 0 ? timeWindowSize : _constants.DEFAULT_VALUES.TIME_WINDOW_SIZE,
    timeWindowUnit: timeWindowUnit !== null && timeWindowUnit !== void 0 ? timeWindowUnit : _constants.DEFAULT_VALUES.TIME_WINDOW_UNIT,
    // ESQL queries compare conditions within the ES query
    // so only 'met' results are returned, therefore the threshold should always be 0
    threshold: [0],
    thresholdComparator: _constants.DEFAULT_VALUES.THRESHOLD_COMPARATOR,
    size: _constants.DEFAULT_VALUES.SIZE,
    esqlQuery: esqlQuery !== null && esqlQuery !== void 0 ? esqlQuery : {
      esql: ''
    },
    aggType: _constants.DEFAULT_VALUES.AGGREGATION_TYPE,
    groupBy: _constants.DEFAULT_VALUES.GROUP_BY,
    termSize: _constants.DEFAULT_VALUES.TERM_SIZE,
    searchType: _types.SearchType.esqlQuery
  });
  const [query, setQuery] = (0, _react.useState)({
    esql: ''
  });
  const [timeFieldOptions, setTimeFieldOptions] = (0, _react.useState)([_common2.firstFieldOption]);
  const [detectTimestamp, setDetectTimestamp] = (0, _react.useState)(false);
  const setParam = (0, _react.useCallback)((paramField, paramValue) => {
    setCurrentRuleParams(currentParams => ({
      ...currentParams,
      [paramField]: paramValue
    }));
    setRuleParams(paramField, paramValue);
  }, [setRuleParams]);
  const setDefaultExpressionValues = async () => {
    setRuleProperty('params', currentRuleParams);
    setQuery(esqlQuery !== null && esqlQuery !== void 0 ? esqlQuery : {
      esql: ''
    });
    if (esqlQuery && 'esql' in esqlQuery) {
      if (esqlQuery.esql) {
        refreshTimeFields(esqlQuery);
      }
    }
    if (timeField) {
      setTimeFieldOptions([_common2.firstFieldOption, {
        text: timeField,
        value: timeField
      }]);
    }
  };
  (0, _react.useEffect)(() => {
    setDefaultExpressionValues();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const onTestQuery = (0, _react.useCallback)(async () => {
    const window = `${timeWindowSize}${timeWindowUnit}`;
    const emptyResult = {
      testResults: {
        results: [],
        truncated: false
      },
      isGrouped: true,
      timeWindow: window
    };
    if ((0, _validation.hasExpressionValidationErrors)(currentRuleParams)) {
      return emptyResult;
    }
    const timeWindow = (0, _common.parseDuration)(window);
    const now = Date.now();
    const table = await (0, _textBasedEditor.fetchFieldsFromESQL)(esqlQuery, expressions, {
      from: new Date(now - timeWindow).toISOString(),
      to: new Date(now).toISOString()
    });
    if (table) {
      const esqlTable = (0, _common3.transformDatatableToEsqlTable)(table);
      const hits = (0, _common3.toEsQueryHits)(esqlTable);
      return {
        testResults: (0, _common2.parseAggregationResults)({
          isCountAgg: true,
          isGroupAgg: false,
          esResult: {
            took: 0,
            timed_out: false,
            _shards: {
              failed: 0,
              successful: 0,
              total: 0
            },
            hits
          }
        }),
        isGrouped: false,
        timeWindow: window,
        rawResults: {
          cols: esqlTable.columns.map(col => ({
            id: col.name
          })),
          rows: esqlTable.values.slice(0, 5).map(row => (0, _common3.rowToDocument)(esqlTable.columns, row))
        }
      };
    }
    return emptyResult;
  }, [timeWindowSize, timeWindowUnit, currentRuleParams, esqlQuery, expressions]);
  const refreshTimeFields = async q => {
    let hasTimestamp = false;
    const indexPattern = (0, _esQuery.getIndexPatternFromESQLQuery)((0, _lodash.get)(q, 'esql'));
    const currentEsFields = await (0, _public.getFields)(http, [indexPattern]);
    const timeFields = (0, _common2.getTimeFieldOptions)(currentEsFields);
    setTimeFieldOptions([_common2.firstFieldOption, ...timeFields]);
    const timestampField = timeFields.find(field => field.value === '@timestamp');
    if (timestampField) {
      setParam('timeField', timestampField.value);
      hasTimestamp = true;
    }
    setDetectTimestamp(hasTimestamp);
  };
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackAlerts.esQuery.ui.defineEsqlQueryPrompt",
    defaultMessage: "Define your query using ES|QL"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "queryEditor",
    "data-test-subj": "queryEsqlEditor",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_public2.TextBasedLangEditor, {
    query: query,
    onTextLangQueryChange: q => {
      setQuery(q);
      setParam('esqlQuery', q);
      refreshTimeFields(q);
    },
    expandCodeEditor: () => true,
    isCodeEditorExpanded: true,
    onTextLangQuerySubmit: () => {},
    detectTimestamp: detectTimestamp,
    hideMinimizeButton: true,
    hideRunQueryText: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackAlerts.esQuery.ui.selectEsqlQueryTimeFieldPrompt",
    defaultMessage: "Select a time field"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "timeField",
    fullWidth: true,
    isInvalid: errors.timeField.length > 0 && timeField !== undefined,
    error: errors.timeField
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: timeFieldOptions,
    isInvalid: errors.timeField.length > 0 && timeField !== undefined,
    fullWidth: true,
    name: "timeField",
    "data-test-subj": "timeFieldSelect",
    value: timeField || '',
    onChange: e => {
      setParam('timeField', e.target.value);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackAlerts.esQuery.ui.setEsqlQueryTimeWindowPrompt",
    defaultMessage: "Set the time window"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "timeWindowSize",
    isInvalid: errors.timeWindowSize.length > 0,
    error: errors.timeWindowSize
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    name: "timeWindowSize",
    "data-test-subj": "timeWindowSizeNumber",
    isInvalid: errors.timeWindowSize.length > 0,
    min: 0,
    value: timeWindowSize || '',
    onChange: e => {
      const {
        value
      } = e.target;
      const timeWindowSizeVal = value !== '' ? parseInt(value, 10) : undefined;
      setParam('timeWindowSize', timeWindowSizeVal);
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "timeWindowUnit"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    name: "timeWindowUnit",
    "data-test-subj": "timeWindowUnitSelect",
    value: timeWindowUnit,
    onChange: e => {
      setParam('timeWindowUnit', e.target.value);
    },
    options: (0, _common2.getTimeOptions)(timeWindowSize !== null && timeWindowSize !== void 0 ? timeWindowSize : 1)
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_test_query_row.TestQueryRow, {
    fetch: onTestQuery,
    hasValidationErrors: (0, _validation.hasExpressionValidationErrors)(currentRuleParams),
    showTable: true
  }));
};
exports.EsqlQueryExpression = EsqlQueryExpression;