"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectsSpacesExtension = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("../../common/constants");
var _namespace = require("../lib/utils/namespace");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SavedObjectsSpacesExtension {
  constructor({
    activeSpaceId,
    spacesClient
  }) {
    (0, _defineProperty2.default)(this, "activeSpaceId", void 0);
    (0, _defineProperty2.default)(this, "spacesClient", void 0);
    this.activeSpaceId = activeSpaceId;
    this.spacesClient = spacesClient;
  }
  getCurrentNamespace(namespace) {
    if (namespace) {
      throw new Error('Namespace cannot be specified by the caller when the spaces extension is enabled. Spaces currently determines the namespace.');
    }
    return (0, _namespace.spaceIdToNamespace)(this.activeSpaceId);
  }
  async getSearchableNamespaces(namespaces) {
    if (!namespaces) {
      // If no namespaces option was specified, fall back to the active space.
      return [this.activeSpaceId];
    } else if (!namespaces.length) {
      // If the namespaces option is empty, return early and let the consumer handle it appropriately.
      return namespaces;
    }
    const availableSpaces = await this.spacesClient.getAll({
      purpose: 'findSavedObjects'
    });
    if (namespaces.includes(_constants.ALL_SPACES_ID)) {
      return availableSpaces.map(space => space.id);
    } else {
      return namespaces.filter(namespace => availableSpaces.some(space => space.id === namespace));
    }
  }
}
exports.SavedObjectsSpacesExtension = SavedObjectsSpacesExtension;