"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManageSpacePage = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/es-ui-shared-plugin/public");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _confirm_alter_active_space_modal = require("./confirm_alter_active_space_modal");
var _customize_space = require("./customize_space");
var _delete_spaces_button = require("./delete_spaces_button");
var _enabled_features = require("./enabled_features");
var _common = require("../../../common");
var _constants = require("../../constants");
var _space_avatar = require("../../space_avatar");
var _components = require("../components");
var _lib = require("../lib");
var _validate_space = require("../lib/validate_space");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ManageSpacePage extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "validator", void 0);
    (0, _defineProperty2.default)(this, "getLoadingIndicator", () => /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
      alignment: "center",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_public.SectionLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.manageSpacePage.loadingMessage",
      defaultMessage: "Loading\u2026"
    }))));
    (0, _defineProperty2.default)(this, "getForm", () => {
      const {
        showAlteringActiveSpaceDialog
      } = this.state;
      return /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": "spaces-edit-page"
      }, /*#__PURE__*/_react.default.createElement(_customize_space.CustomizeSpace, {
        space: this.state.space,
        onChange: this.onSpaceChange,
        editingExistingSpace: this.editingExistingSpace(),
        validator: this.validator
      }), this.props.allowFeatureVisibility && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_enabled_features.EnabledFeatures, {
        space: this.state.space,
        features: this.state.features,
        onChange: this.onSpaceChange
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), this.getFormButtons(), showAlteringActiveSpaceDialog && /*#__PURE__*/_react.default.createElement(_confirm_alter_active_space_modal.ConfirmAlterActiveSpaceModal, {
        onConfirm: () => this.performSave(true),
        onCancel: () => {
          this.setState({
            showAlteringActiveSpaceDialog: false
          });
        }
      }));
    });
    (0, _defineProperty2.default)(this, "getTitle", () => {
      if (this.editingExistingSpace()) {
        return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.spaces.management.manageSpacePage.editSpaceTitle",
          defaultMessage: "Edit space"
        });
      }
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.spaces.management.manageSpacePage.createSpaceTitle",
        defaultMessage: "Create space"
      });
    });
    (0, _defineProperty2.default)(this, "getFormButtons", () => {
      const createSpaceText = _i18n.i18n.translate('xpack.spaces.management.manageSpacePage.createSpaceButton', {
        defaultMessage: 'Create space'
      });
      const updateSpaceText = _i18n.i18n.translate('xpack.spaces.management.manageSpacePage.updateSpaceButton', {
        defaultMessage: 'Update space'
      });
      const cancelButtonText = _i18n.i18n.translate('xpack.spaces.management.manageSpacePage.cancelSpaceButton', {
        defaultMessage: 'Cancel'
      });
      const saveText = this.editingExistingSpace() ? updateSpaceText : createSpaceText;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        responsive: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        fill: true,
        onClick: this.saveSpace,
        "data-test-subj": "save-space-button",
        isLoading: this.state.saveInProgress
      }, saveText)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        onClick: this.backToSpacesList,
        "data-test-subj": "cancel-space-button"
      }, cancelButtonText)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: true
      }), this.getActionButton());
    });
    (0, _defineProperty2.default)(this, "getActionButton", () => {
      if (this.state.space && this.editingExistingSpace() && !(0, _common.isReservedSpace)(this.state.space)) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_delete_spaces_button.DeleteSpacesButton, {
          "data-test-subj": "delete-space-button",
          space: this.state.space,
          spacesManager: this.props.spacesManager,
          onDelete: this.backToSpacesList,
          notifications: this.props.notifications
        }));
      }
      return null;
    });
    (0, _defineProperty2.default)(this, "onSpaceChange", updatedSpace => {
      this.setState({
        space: updatedSpace
      });
    });
    (0, _defineProperty2.default)(this, "saveSpace", () => {
      this.validator.enableValidation();
      const originalSpace = this.state.originalSpace;
      const space = this.state.space;
      const result = this.validator.validateForSave(space);
      if (result.isInvalid) {
        this.setState({
          formError: result
        });
        return;
      }
      if (this.editingExistingSpace()) {
        const {
          spacesManager
        } = this.props;
        spacesManager.getActiveSpace().then(activeSpace => {
          const editingActiveSpace = activeSpace.id === originalSpace.id;
          const haveDisabledFeaturesChanged = space.disabledFeatures.length !== originalSpace.disabledFeatures.length || (0, _lodash.difference)(space.disabledFeatures, originalSpace.disabledFeatures).length > 0;
          if (editingActiveSpace && haveDisabledFeaturesChanged) {
            this.setState({
              showAlteringActiveSpaceDialog: true
            });
            return;
          }
          this.performSave();
        });
      } else {
        this.performSave();
      }
    });
    (0, _defineProperty2.default)(this, "loadSpace", async (spaceId, featuresPromise) => {
      const {
        spacesManager,
        onLoadSpace
      } = this.props;
      try {
        const [space, features] = await Promise.all([spacesManager.getSpace(spaceId), featuresPromise]);
        if (space) {
          if (onLoadSpace) {
            onLoadSpace(space);
          }
          this.setState({
            space: {
              ...space,
              avatarType: space.imageUrl ? 'image' : 'initials',
              initials: space.initials || (0, _space_avatar.getSpaceInitials)(space),
              color: space.color || (0, _space_avatar.getSpaceColor)(space),
              customIdentifier: false,
              customAvatarInitials: !!space.initials && (0, _space_avatar.getSpaceInitials)({
                name: space.name
              }) !== space.initials,
              customAvatarColor: !!space.color && (0, _space_avatar.getSpaceColor)({
                name: space.name
              }) !== space.color
            },
            features,
            originalSpace: space,
            isLoading: false
          });
        }
      } catch (error) {
        var _error$body$message, _error$body;
        const message = (_error$body$message = error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : '';
        this.props.notifications.toasts.addDanger(_i18n.i18n.translate('xpack.spaces.management.manageSpacePage.errorLoadingSpaceTitle', {
          defaultMessage: 'Error loading space: {message}',
          values: {
            message
          }
        }));
        this.backToSpacesList();
      }
    });
    (0, _defineProperty2.default)(this, "performSave", (requireRefresh = false) => {
      if (!this.state.space) {
        return;
      }
      const name = this.state.space.name || '';
      const {
        id = (0, _lib.toSpaceIdentifier)(name),
        description,
        initials,
        color,
        disabledFeatures = [],
        imageUrl,
        avatarType
      } = this.state.space;
      const params = {
        name,
        id,
        description,
        initials: avatarType !== 'image' ? initials : '',
        color: color ? (0, _eui.hsvToHex)((0, _eui.hexToHsv)(color)).toUpperCase() : color,
        // Convert 3 digit hex codes to 6 digits since Spaces API requires 6 digits
        disabledFeatures,
        imageUrl: avatarType === 'image' ? imageUrl : ''
      };
      let action;
      if (this.editingExistingSpace()) {
        action = this.props.spacesManager.updateSpace(params);
      } else {
        action = this.props.spacesManager.createSpace(params);
      }
      this.setState({
        saveInProgress: true
      });
      action.then(() => {
        this.props.notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.spaces.management.manageSpacePage.spaceSuccessfullySavedNotificationMessage', {
          defaultMessage: `Space {name} was saved.`,
          values: {
            name: `'${name}'`
          }
        }));
        this.backToSpacesList();
        if (requireRefresh) {
          setTimeout(() => {
            window.location.reload();
          });
        }
      }).catch(error => {
        var _error$body$message2, _error$body2;
        const message = (_error$body$message2 = error === null || error === void 0 ? void 0 : (_error$body2 = error.body) === null || _error$body2 === void 0 ? void 0 : _error$body2.message) !== null && _error$body$message2 !== void 0 ? _error$body$message2 : '';
        this.setState({
          saveInProgress: false
        });
        this.props.notifications.toasts.addDanger(_i18n.i18n.translate('xpack.spaces.management.manageSpacePage.errorSavingSpaceTitle', {
          defaultMessage: 'Error saving space: {message}',
          values: {
            message
          }
        }));
      });
    });
    (0, _defineProperty2.default)(this, "backToSpacesList", () => this.props.history.push('/'));
    (0, _defineProperty2.default)(this, "editingExistingSpace", () => !!this.props.spaceId);
    this.validator = new _validate_space.SpaceValidator({
      shouldValidate: false
    });
    this.state = {
      isLoading: true,
      showAlteringActiveSpaceDialog: false,
      saveInProgress: false,
      space: {
        color: (0, _space_avatar.getSpaceColor)({})
      },
      features: []
    };
  }
  async componentDidMount() {
    if (!this.props.capabilities.spaces.manage) {
      return;
    }
    const {
      spaceId,
      getFeatures,
      notifications
    } = this.props;
    try {
      if (spaceId) {
        await this.loadSpace(spaceId, getFeatures());
      } else {
        const features = await getFeatures();
        this.setState({
          isLoading: false,
          features
        });
      }
    } catch (e) {
      notifications.toasts.addError(e, {
        title: _i18n.i18n.translate('xpack.spaces.management.manageSpacePage.loadErrorTitle', {
          defaultMessage: 'Error loading available features'
        })
      });
    }
  }
  async componentDidUpdate(previousProps) {
    if (this.props.spaceId !== previousProps.spaceId && this.props.spaceId) {
      await this.loadSpace(this.props.spaceId, Promise.resolve(this.state.features));
    }
  }
  render() {
    if (!this.props.capabilities.spaces.manage) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
        alignment: "center",
        color: "danger"
      }, /*#__PURE__*/_react.default.createElement(_components.UnauthorizedPrompt, null));
    }
    if (this.state.isLoading) {
      return this.getLoadingIndicator();
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
      restrictWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
      pageTitle: this.getTitle(),
      description: (0, _constants.getSpacesFeatureDescription)()
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), this.getForm());
  }
}
exports.ManageSpacePage = ManageSpacePage;