"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectableSpacesControl = void 0;
require("./selectable_spaces_control.scss");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _common = require("../../../common");
var _space_avatar = require("../../space_avatar");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// No need to wrap LazySpaceAvatar in an error boundary, because it is one of the first chunks loaded when opening Kibana.
const LazySpaceAvatar = /*#__PURE__*/(0, _react.lazy)(() => (0, _space_avatar.getSpaceAvatarComponent)().then(component => ({
  default: component
})));
const SelectableSpacesControl = props => {
  if (props.spaces.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null);
  }
  const disabledIndicator = /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.copyToSpace.selectSpacesControl.disabledTooltip",
      defaultMessage: "The object or a related object already exists in this space."
    }),
    position: "left",
    type: "iInCircle"
  });
  const options = props.spaces.map(space => {
    const disabled = props.disabledSpaceIds.has(space.id);
    return {
      label: space.name,
      prepend: /*#__PURE__*/_react.default.createElement(LazySpaceAvatar, {
        space: space,
        size: 's'
      }),
      // wrapped in a Suspense below
      append: disabled ? disabledIndicator : null,
      checked: props.selectedSpaceIds.includes(space.id) ? 'on' : undefined,
      disabled,
      ['data-space-id']: space.id,
      ['data-test-subj']: `cts-space-selector-row-${space.id}`
    };
  });
  function updateSelectedSpaces(selectedOptions) {
    if (props.disabled) return;
    const selectedSpaceIds = selectedOptions.filter(opt => opt.checked).map(opt => opt['data-space-id']);
    props.onChange(selectedSpaceIds);
  }
  return /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    options: options,
    onChange: newOptions => updateSelectedSpaces(newOptions),
    listProps: {
      bordered: true,
      rowHeight: 40,
      className: 'spcCopyToSpace__spacesList',
      'data-test-subj': 'cts-form-space-selector'
    },
    searchable: options.length > _common.SPACE_SEARCH_COUNT_THRESHOLD
  }, (list, search) => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, search, list);
  }));
};
exports.SelectableSpacesControl = SelectableSpacesControl;