"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapshotState = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../../constants");
var _app_context = require("../../../../../app_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SnapshotState = ({
  state
}) => {
  const {
    i18n
  } = (0, _app_context.useServices)();
  const stateMap = {
    [_constants.SNAPSHOT_STATE.IN_PROGRESS]: {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "m"
      }),
      label: i18n.translate('xpack.snapshotRestore.snapshotState.inProgressLabel', {
        defaultMessage: 'Taking snapshot…'
      })
    },
    [_constants.SNAPSHOT_STATE.SUCCESS]: {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        color: "success",
        type: "check"
      }),
      label: i18n.translate('xpack.snapshotRestore.snapshotState.completeLabel', {
        defaultMessage: 'Snapshot complete'
      })
    },
    [_constants.SNAPSHOT_STATE.FAILED]: {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        color: "danger",
        type: "cross"
      }),
      label: i18n.translate('xpack.snapshotRestore.snapshotState.failedLabel', {
        defaultMessage: 'Snapshot failed'
      })
    },
    [_constants.SNAPSHOT_STATE.PARTIAL]: {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        color: "warning",
        type: "warning"
      }),
      label: i18n.translate('xpack.snapshotRestore.snapshotState.partialLabel', {
        defaultMessage: 'Partial failure'
      }),
      tip: i18n.translate('xpack.snapshotRestore.snapshotState.partialTipDescription', {
        defaultMessage: `Global cluster state was stored, but at least one shard wasn't stored successfully. See the 'Failed indices' tab.`
      })
    },
    [_constants.SNAPSHOT_STATE.INCOMPATIBLE]: {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        color: "warning",
        type: "warning"
      }),
      label: i18n.translate('xpack.snapshotRestore.snapshotState.incompatibleLabel', {
        defaultMessage: 'Incompatible version'
      }),
      tip: i18n.translate('xpack.snapshotRestore.snapshotState.incompatibleTipDescription', {
        defaultMessage: `Snapshot was created with a version of Elasticsearch incompatible with the cluster's version.`
      })
    }
  };
  if (!stateMap[state]) {
    // Help debug unexpected state.
    return state;
  }
  const {
    icon,
    label,
    tip
  } = stateMap[state];
  const iconTip = tip && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: tip
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, icon), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", null, label, iconTip)));
};
exports.SnapshotState = SnapshotState;