"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyStepReview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _lib = require("../../../../../common/lib");
var _app_context = require("../../../app_context");
var _collapsible_lists = require("../../collapsible_lists");
var _summaries = require("../../summaries");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PolicyStepReview = ({
  policy,
  updateCurrentStep
}) => {
  const {
    i18n
  } = (0, _app_context.useServices)();
  const {
    name,
    snapshotName,
    schedule,
    repository,
    config,
    retention
  } = policy;
  const {
    indices,
    includeGlobalState,
    featureStates,
    ignoreUnavailable,
    partial
  } = config || {
    indices: undefined,
    includeGlobalState: undefined,
    featureStates: [],
    ignoreUnavailable: undefined,
    partial: undefined
  };
  const serializedPolicy = (0, _lib.serializePolicy)(policy);
  const {
    retention: serializedRetention
  } = serializedPolicy;
  const EditStepTooltip = ({
    step
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepReview.summaryTab.editStepTooltip",
      defaultMessage: "Edit"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => updateCurrentStep(step)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "pencil",
    "aria-label": i18n.translate('xpack.snapshotRestore.policyForm.stepReview.editIconAriaLabel', {
      defaultMessage: 'Edit step'
    })
  })));
  const renderSummaryTab = () => /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.stepReview.summaryTab.sectionLogisticsTitle",
    defaultMessage: "Logistics"
  }), ' ', /*#__PURE__*/_react.default.createElement(EditStepTooltip, {
    step: 1
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.stepReview.summaryTab.nameLabel",
    defaultMessage: "Policy name"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, name))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.stepReview.summaryTab.snapshotNameLabel",
    defaultMessage: "Snapshot name"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, snapshotName)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.stepReview.summaryTab.repositoryLabel",
    defaultMessage: "Repository"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, repository))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.stepReview.summaryTab.scheduleLabel",
    defaultMessage: "Schedule"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, schedule)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.stepReview.summaryTab.sectionSettingsTitle",
    defaultMessage: "Snapshot settings"
  }), ' ', /*#__PURE__*/_react.default.createElement(EditStepTooltip, {
    step: 2
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.stepReview.summaryTab.dataStreamsAndIndicesLabel",
    defaultMessage: "Data streams and indices"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(_collapsible_lists.CollapsibleIndicesList, {
    indices: indices
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.stepReview.summaryTab.ignoreUnavailableLabel",
    defaultMessage: "Ignore unavailable indices"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, ignoreUnavailable ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.stepReview.summaryTab.ignoreUnavailableTrueLabel",
    defaultMessage: "Yes"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.stepReview.summaryTab.ignoreUnavailableFalseLabel",
    defaultMessage: "No"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.stepReview.summaryTab.includeGlobalStateLabel",
    defaultMessage: "Include global state"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, includeGlobalState === false ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.stepReview.summaryTab.includeGlobalStateFalseLabel",
    defaultMessage: "No"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.stepReview.summaryTab.includeGlobalStateTrueLabel",
    defaultMessage: "Yes"
  })))), /*#__PURE__*/_react.default.createElement(_summaries.PolicyFeatureStatesSummary, {
    includeGlobalState: includeGlobalState,
    featureStates: featureStates
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.stepReview.summaryTab.partialIndicesLabel",
    defaultMessage: "Allow partial indices"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, partial ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.stepReview.summaryTab.partialTrueLabel",
    defaultMessage: "Yes"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.stepReview.summaryTab.partialFalseLabel",
    defaultMessage: "No"
  }))))), serializedRetention ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.stepReview.retentionTab.sectionRetentionTitle",
    defaultMessage: "Snapshot retention"
  }), ' ', /*#__PURE__*/_react.default.createElement(EditStepTooltip, {
    step: 3
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, retention.expireAfterValue && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.stepReview.retentionTab.expireAfterLabel",
    defaultMessage: "Delete after"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, retention.expireAfterValue, retention.expireAfterUnit)), retention.minCount && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.stepReview.retentionTab.minCountLabel",
    defaultMessage: "Min count"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, retention.minCount)), retention.maxCount && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.stepReview.retentionTab.maxCountLabel",
    defaultMessage: "Max count"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, retention.maxCount)))) : null);
  const renderRequestTab = () => {
    const endpoint = `PUT _slm/policy/${name}`;
    const json = JSON.stringify(serializedPolicy, null, 2);
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "json",
      isCopyable: true
    }, `${endpoint}\n${json}`));
  };
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.stepReviewTitle",
    defaultMessage: "Review policy"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: [{
      id: 'summary',
      name: i18n.translate('xpack.snapshotRestore.policyForm.stepReview.summaryTabTitle', {
        defaultMessage: 'Summary'
      }),
      content: renderSummaryTab()
    }, {
      id: 'json',
      name: i18n.translate('xpack.snapshotRestore.policyForm.stepReview.requestTabTitle', {
        defaultMessage: 'Request'
      }),
      content: renderRequestTab()
    }]
  }));
};
exports.PolicyStepReview = PolicyStepReview;