"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeatureStatesFormField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _app_context = require("../../app_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FeatureStatesFormField = ({
  isLoadingFeatures = false,
  featuresOptions,
  selectedOptions,
  onUpdateFormSettings
}) => {
  const {
    i18n
  } = (0, _app_context.useServices)();
  const optionsList = (0, _react.useMemo)(() => {
    if (!isLoadingFeatures) {
      const featuresList = featuresOptions.map(feature => ({
        label: feature
      }));
      return (0, _lodash.sortBy)(featuresList, 'label');
    }
    return [];
  }, [isLoadingFeatures, featuresOptions]);
  const onChange = selected => {
    onUpdateFormSettings({
      featureStates: selected.map(option => option.label)
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "featureStatesDropdown",
    placeholder: i18n.translate('xpack.snapshotRestore.featureStatesFormField.allFeaturesLabel', {
      defaultMessage: 'All features'
    }),
    options: optionsList,
    selectedOptions: selectedOptions,
    onChange: onChange,
    isLoading: isLoadingFeatures,
    isClearable: true
  }));
};
exports.FeatureStatesFormField = FeatureStatesFormField;