"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaErrorService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _telemetry_events = require("../../lib/telemetry_events");
var _throw_if_error = require("../ui/throw_if_error");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const MATCH_CHUNK_LOADERROR = /ChunkLoadError/;
/**
 * Kibana Error Boundary Services: Error Service
 * Each Error Boundary tracks an instance of this class
 * @internal
 */
class KibanaErrorService {
  constructor(deps) {
    (0, _defineProperty2.default)(this, "analytics", void 0);
    this.analytics = deps.analytics;
  }

  /**
   * Determines if the error fallback UI should appear as an apologetic but promising "Refresh" button,
   * or treated with "danger" coloring and include a detailed error message.
   */
  getIsFatal(error) {
    const isChunkLoadError = MATCH_CHUNK_LOADERROR.test(error.name);
    return !isChunkLoadError; // "ChunkLoadError" is recoverable by refreshing the page
  }

  /**
   * Derive the name of the component that threw the error
   */
  getErrorComponentName(errorInfo) {
    var _errorInfo$componentS;
    let errorComponentName = null;
    const stackLines = errorInfo === null || errorInfo === void 0 ? void 0 : (_errorInfo$componentS = errorInfo.componentStack) === null || _errorInfo$componentS === void 0 ? void 0 : _errorInfo$componentS.split('\n');
    const errorIndicator = /^    at (\S+).*/;
    if (stackLines) {
      let i = 0;
      while (i < stackLines.length - 1) {
        // scan the stack trace text
        if (stackLines[i].match(errorIndicator)) {
          // extract the name of the bad component
          errorComponentName = stackLines[i].replace(errorIndicator, '$1');
          // If the component is the utility for throwing errors, skip
          if (errorComponentName && errorComponentName !== _throw_if_error.ThrowIfError.name) {
            break;
          }
        }
        i++;
      }
    }
    return errorComponentName;
  }

  /**
   * Creates a decorated error object
   */
  registerError(error, errorInfo) {
    const isFatal = this.getIsFatal(error);
    const name = this.getErrorComponentName(errorInfo);
    try {
      if (isFatal) {
        var _this$analytics;
        (_this$analytics = this.analytics) === null || _this$analytics === void 0 ? void 0 : _this$analytics.reportEvent(_telemetry_events.REACT_FATAL_ERROR_EVENT_TYPE, {
          component_name: name,
          error_message: error.toString()
        });
      }
    } catch (e) {
      // eslint-disable-next-line no-console
      console.error(e);
    }
    return {
      error,
      errorInfo,
      isFatal,
      name
    };
  }
}
exports.KibanaErrorService = KibanaErrorService;