"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerUrlServiceSavedObjectType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const registerUrlServiceSavedObjectType = (so, service) => {
  const urlSavedObjectType = {
    name: 'url',
    namespaceType: 'single',
    hidden: false,
    management: {
      icon: 'link',
      defaultSearchField: 'url',
      importableAndExportable: true,
      getTitle(obj) {
        return `/goto/${encodeURIComponent(obj.id)}`;
      },
      getInAppUrl(obj) {
        return {
          path: '/goto/' + encodeURIComponent(obj.id),
          uiCapabilitiesPath: ''
        };
      }
    },
    mappings: {
      dynamic: false,
      properties: {
        slug: {
          type: 'text',
          fields: {
            keyword: {
              type: 'keyword'
            }
          }
        },
        accessDate: {
          type: 'date'
        },
        createDate: {
          type: 'date'
        }
      }
    },
    migrations: () => {
      const locatorMigrations = service.locators.getAllMigrations();
      const savedObjectLocatorMigrations = {};
      for (const [version, locatorMigration] of Object.entries(locatorMigrations)) {
        savedObjectLocatorMigrations[version] = doc => {
          const locator = JSON.parse(doc.attributes.locatorJSON);
          doc.attributes = {
            ...doc.attributes,
            locatorJSON: JSON.stringify(locatorMigration(locator))
          };
          return doc;
        };
      }
      return savedObjectLocatorMigrations;
    }
  };
  so.registerType(urlSavedObjectType);
};
exports.registerUrlServiceSavedObjectType = registerUrlServiceSavedObjectType;