"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RedirectEmptyPrompt = void 0;
var React = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sharedUxPromptNotFound = require("@kbn/shared-ux-prompt-not-found");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const defaultTitle = _i18n.i18n.translate('share.urlService.redirect.components.Error.title', {
  defaultMessage: 'Unable to open URL',
  description: 'Title displayed to user in redirect endpoint when redirection cannot be performed successfully.'
});
const defaultBody = _i18n.i18n.translate('share.urlService.redirect.components.Error.body', {
  defaultMessage: `Sorry, the object you're looking for can't be found at this URL.` + ` It might have been removed or maybe it never existed.`
});
const RedirectEmptyPrompt = ({
  title = defaultTitle,
  body = defaultBody,
  homeHref,
  docTitle,
  error
}) => {
  // eslint-disable-next-line no-console
  console.error('Short URL redirect error', error);
  docTitle.change(_i18n.i18n.translate('share.urlService.redirect.components.docTitle', {
    defaultMessage: 'Not Found'
  }));
  return /*#__PURE__*/React.createElement(_sharedUxPromptNotFound.NotFoundPrompt, {
    title: /*#__PURE__*/React.createElement("h2", null, title),
    body: /*#__PURE__*/React.createElement("p", {
      "data-test-subj": "redirectErrorEmptyPromptBody"
    }, body),
    actions: /*#__PURE__*/React.createElement(_eui.EuiButtonEmpty, {
      iconType: "arrowLeft",
      href: homeHref,
      "data-test-subj": "redirectErrorEmptyPromptButton"
    }, _i18n.i18n.translate('share.urlService.redirect.components.Error.homeButton', {
      defaultMessage: 'Back to home'
    }))
  });
};
exports.RedirectEmptyPrompt = RedirectEmptyPrompt;