"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SplitText = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Split a text into multiple spans, each of which a single character. This is
// useful for creating inline "like" text but still having control over the blocks
// exclusive features, such height or line-height.
const css = {};
const SplitText = ({
  children,
  role = 'document',
  highlightIndices,
  highlightStyle,
  ...props
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children.split('').map(function (char, index) {
    const isHighlighted = highlightIndices === null || highlightIndices === void 0 ? void 0 : highlightIndices.includes(index);
    return /*#__PURE__*/_react.default.createElement("span", (0, _extends2.default)({
      "aria-hidden": "true",
      css: isHighlighted ? highlightStyle : css,
      key: index
    }, isHighlighted ? {
      'data-test-subj': `sessionView:splitTextIsHighlighted`
    } : {}, props), char === ' ' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0") : char);
  }));
};
exports.SplitText = SplitText;