"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStyles = void 0;
var _react = require("react");
var _eui = require("@elastic/eui");
var _hooks = require("../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStyles = () => {
  const {
    euiTheme,
    euiVars
  } = (0, _hooks.useEuiTheme)();
  const cached = (0, _react.useMemo)(() => {
    const {
      colors,
      font,
      size
    } = euiTheme;
    const defaultSelectionColor = colors.primary;
    const sessionViewProcessTree = {
      position: 'relative',
      fontFamily: font.familyCode,
      overflow: 'auto',
      height: '100%',
      backgroundColor: euiVars.euiColorLightestShade
    };
    const selectionArea = {
      position: 'absolute',
      display: 'none',
      marginLeft: '-50%',
      width: '150%',
      height: '100%',
      backgroundColor: defaultSelectionColor,
      pointerEvents: 'none',
      opacity: 0.1,
      transform: `translateY(-${size.xs})`
    };
    const defaultSelected = (0, _eui.transparentize)(colors.primary, 0.008);
    const alertSelected = (0, _eui.transparentize)(colors.danger, 0.008);
    return {
      sessionViewProcessTree,
      selectionArea,
      defaultSelected,
      alertSelected
    };
  }, [euiTheme, euiVars]);
  return cached;
};
exports.useStyles = useStyles;