"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOrchestratorData = exports.getHostData = exports.getContainerData = exports.getCloudData = void 0;
var _constants = require("../../constants");
var _data_or_dash = require("../../utils/data_or_dash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getHostData = host => {
  var _host$ip$map$join, _host$ip, _host$ip$map, _host$mac$map$join, _host$mac, _host$mac$map, _host$os, _host$os2, _host$os3, _host$os4, _host$os5, _host$os6;
  const detailPanelHost = {
    architecture: _constants.DASH,
    hostname: _constants.DASH,
    id: _constants.DASH,
    ip: _constants.DASH,
    mac: _constants.DASH,
    name: _constants.DASH,
    os: {
      family: _constants.DASH,
      full: _constants.DASH,
      kernel: _constants.DASH,
      name: _constants.DASH,
      platform: _constants.DASH,
      version: _constants.DASH
    }
  };
  if (!host) {
    return detailPanelHost;
  }
  detailPanelHost.hostname = (0, _data_or_dash.dataOrDash)(host.hostname).toString();
  detailPanelHost.id = (0, _data_or_dash.dataOrDash)(host.id).toString();
  detailPanelHost.ip = (_host$ip$map$join = (_host$ip = host.ip) === null || _host$ip === void 0 ? void 0 : (_host$ip$map = _host$ip.map) === null || _host$ip$map === void 0 ? void 0 : _host$ip$map.call(_host$ip, ip => (0, _data_or_dash.dataOrDash)(ip)).join(', ')) !== null && _host$ip$map$join !== void 0 ? _host$ip$map$join : _constants.DASH;
  detailPanelHost.mac = (_host$mac$map$join = (_host$mac = host.mac) === null || _host$mac === void 0 ? void 0 : (_host$mac$map = _host$mac.map) === null || _host$mac$map === void 0 ? void 0 : _host$mac$map.call(_host$mac, mac => (0, _data_or_dash.dataOrDash)(mac)).join(', ')) !== null && _host$mac$map$join !== void 0 ? _host$mac$map$join : _constants.DASH;
  detailPanelHost.name = (0, _data_or_dash.dataOrDash)(host.name).toString();
  detailPanelHost.architecture = (0, _data_or_dash.dataOrDash)(host.architecture).toString();
  detailPanelHost.os.family = (0, _data_or_dash.dataOrDash)((_host$os = host.os) === null || _host$os === void 0 ? void 0 : _host$os.family).toString();
  detailPanelHost.os.full = (0, _data_or_dash.dataOrDash)((_host$os2 = host.os) === null || _host$os2 === void 0 ? void 0 : _host$os2.full).toString();
  detailPanelHost.os.kernel = (0, _data_or_dash.dataOrDash)((_host$os3 = host.os) === null || _host$os3 === void 0 ? void 0 : _host$os3.kernel).toString();
  detailPanelHost.os.name = (0, _data_or_dash.dataOrDash)((_host$os4 = host.os) === null || _host$os4 === void 0 ? void 0 : _host$os4.name).toString();
  detailPanelHost.os.platform = (0, _data_or_dash.dataOrDash)((_host$os5 = host.os) === null || _host$os5 === void 0 ? void 0 : _host$os5.platform).toString();
  detailPanelHost.os.version = (0, _data_or_dash.dataOrDash)((_host$os6 = host.os) === null || _host$os6 === void 0 ? void 0 : _host$os6.version).toString();
  return detailPanelHost;
};
exports.getHostData = getHostData;
const getContainerData = container => {
  var _container$image, _container$image2, _container$image3, _container$image3$has;
  const detailPanelContainer = {
    id: _constants.DASH,
    name: _constants.DASH,
    image: {
      name: _constants.DASH,
      tag: _constants.DASH,
      hash: {
        all: _constants.DASH
      }
    }
  };
  if (!container) {
    return detailPanelContainer;
  }
  detailPanelContainer.id = (0, _data_or_dash.dataOrDash)(container.id).toString();
  detailPanelContainer.name = (0, _data_or_dash.dataOrDash)(container.name).toString();
  detailPanelContainer.image.name = (0, _data_or_dash.dataOrDash)(container === null || container === void 0 ? void 0 : (_container$image = container.image) === null || _container$image === void 0 ? void 0 : _container$image.name).toString();
  detailPanelContainer.image.tag = (0, _data_or_dash.dataOrDash)(container === null || container === void 0 ? void 0 : (_container$image2 = container.image) === null || _container$image2 === void 0 ? void 0 : _container$image2.tag).toString();
  detailPanelContainer.image.hash.all = (0, _data_or_dash.dataOrDash)(container === null || container === void 0 ? void 0 : (_container$image3 = container.image) === null || _container$image3 === void 0 ? void 0 : (_container$image3$has = _container$image3.hash) === null || _container$image3$has === void 0 ? void 0 : _container$image3$has.all).toString();
  return detailPanelContainer;
};
exports.getContainerData = getContainerData;
const getOrchestratorData = orchestrator => {
  var _orchestrator$resourc, _orchestrator$resourc2, _orchestrator$resourc3, _orchestrator$cluster, _orchestrator$cluster2, _orchestrator$resourc4, _orchestrator$resourc5;
  const detailPanelOrchestrator = {
    resource: {
      name: _constants.DASH,
      type: _constants.DASH,
      ip: _constants.DASH,
      parent: {
        type: _constants.DASH
      }
    },
    namespace: _constants.DASH,
    cluster: {
      name: _constants.DASH,
      id: _constants.DASH
    }
  };
  if (!orchestrator) {
    return detailPanelOrchestrator;
  }
  detailPanelOrchestrator.resource.name = (0, _data_or_dash.dataOrDash)(orchestrator === null || orchestrator === void 0 ? void 0 : (_orchestrator$resourc = orchestrator.resource) === null || _orchestrator$resourc === void 0 ? void 0 : _orchestrator$resourc.name).toString();
  detailPanelOrchestrator.resource.type = (0, _data_or_dash.dataOrDash)(orchestrator === null || orchestrator === void 0 ? void 0 : (_orchestrator$resourc2 = orchestrator.resource) === null || _orchestrator$resourc2 === void 0 ? void 0 : _orchestrator$resourc2.type).toString();
  detailPanelOrchestrator.resource.ip = (0, _data_or_dash.dataOrDash)(orchestrator === null || orchestrator === void 0 ? void 0 : (_orchestrator$resourc3 = orchestrator.resource) === null || _orchestrator$resourc3 === void 0 ? void 0 : _orchestrator$resourc3.ip).toString();
  detailPanelOrchestrator.namespace = (0, _data_or_dash.dataOrDash)(orchestrator === null || orchestrator === void 0 ? void 0 : orchestrator.namespace).toString();
  detailPanelOrchestrator.cluster.name = (0, _data_or_dash.dataOrDash)(orchestrator === null || orchestrator === void 0 ? void 0 : (_orchestrator$cluster = orchestrator.cluster) === null || _orchestrator$cluster === void 0 ? void 0 : _orchestrator$cluster.name).toString();
  detailPanelOrchestrator.cluster.id = (0, _data_or_dash.dataOrDash)(orchestrator === null || orchestrator === void 0 ? void 0 : (_orchestrator$cluster2 = orchestrator.cluster) === null || _orchestrator$cluster2 === void 0 ? void 0 : _orchestrator$cluster2.id).toString();
  detailPanelOrchestrator.resource.parent.type = (0, _data_or_dash.dataOrDash)(orchestrator === null || orchestrator === void 0 ? void 0 : (_orchestrator$resourc4 = orchestrator.resource) === null || _orchestrator$resourc4 === void 0 ? void 0 : (_orchestrator$resourc5 = _orchestrator$resourc4.parent) === null || _orchestrator$resourc5 === void 0 ? void 0 : _orchestrator$resourc5.type).toString();
  return detailPanelOrchestrator;
};
exports.getOrchestratorData = getOrchestratorData;
const getCloudData = cloud => {
  var _cloud$instance, _cloud$account, _cloud$project, _cloud$project2;
  const detailPanelCloud = {
    instance: {
      name: _constants.DASH
    },
    account: {
      id: _constants.DASH
    },
    project: {
      id: _constants.DASH,
      name: _constants.DASH
    },
    provider: _constants.DASH,
    region: _constants.DASH
  };
  if (!cloud) {
    return detailPanelCloud;
  }
  detailPanelCloud.instance.name = (0, _data_or_dash.dataOrDash)(cloud === null || cloud === void 0 ? void 0 : (_cloud$instance = cloud.instance) === null || _cloud$instance === void 0 ? void 0 : _cloud$instance.name).toString();
  detailPanelCloud.account.id = (0, _data_or_dash.dataOrDash)(cloud === null || cloud === void 0 ? void 0 : (_cloud$account = cloud.account) === null || _cloud$account === void 0 ? void 0 : _cloud$account.id).toString();
  detailPanelCloud.project.id = (0, _data_or_dash.dataOrDash)(cloud === null || cloud === void 0 ? void 0 : (_cloud$project = cloud.project) === null || _cloud$project === void 0 ? void 0 : _cloud$project.id).toString();
  detailPanelCloud.project.name = (0, _data_or_dash.dataOrDash)(cloud === null || cloud === void 0 ? void 0 : (_cloud$project2 = cloud.project) === null || _cloud$project2 === void 0 ? void 0 : _cloud$project2.name).toString();
  detailPanelCloud.provider = (0, _data_or_dash.dataOrDash)(cloud === null || cloud === void 0 ? void 0 : cloud.provider).toString();
  detailPanelCloud.region = (0, _data_or_dash.dataOrDash)(cloud === null || cloud === void 0 ? void 0 : cloud.region).toString();
  return detailPanelCloud;
};
exports.getCloudData = getCloudData;