"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SHOW_DETAILS_TEST_ID = exports.JUMP_TO_PROCESS_TEST_ID = exports.DetailPanelAlertActions = exports.BUTTON_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BUTTON_TEST_ID = 'sessionView:detailPanelAlertActionsBtn';
exports.BUTTON_TEST_ID = BUTTON_TEST_ID;
const SHOW_DETAILS_TEST_ID = 'sessionView:detailPanelAlertActionShowDetails';
exports.SHOW_DETAILS_TEST_ID = SHOW_DETAILS_TEST_ID;
const JUMP_TO_PROCESS_TEST_ID = 'sessionView:detailPanelAlertActionJumpToProcess';
exports.JUMP_TO_PROCESS_TEST_ID = JUMP_TO_PROCESS_TEST_ID;
/**
 * Detail panel alert context menu actions
 */
const DetailPanelAlertActions = ({
  event,
  onShowAlertDetails,
  onJumpToEvent
}) => {
  var _event$kibana$alert$u, _event$kibana2, _event$kibana2$alert;
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const onClosePopover = (0, _react.useCallback)(() => {
    setPopover(false);
  }, []);
  const onToggleMenu = (0, _react.useCallback)(() => {
    setPopover(!isPopoverOpen);
  }, [isPopoverOpen]);
  const onJumpToAlert = (0, _react.useCallback)(() => {
    onJumpToEvent(event);
    setPopover(false);
  }, [event, onJumpToEvent]);
  const onShowDetails = (0, _react.useCallback)(() => {
    var _event$kibana, _event$kibana$alert;
    if ((_event$kibana = event.kibana) !== null && _event$kibana !== void 0 && (_event$kibana$alert = _event$kibana.alert) !== null && _event$kibana$alert !== void 0 && _event$kibana$alert.uuid) {
      onShowAlertDetails(event.kibana.alert.uuid);
      setPopover(false);
    }
  }, [event, onShowAlertDetails]);
  if (!event.kibana) {
    return null;
  }
  const uuid = (_event$kibana$alert$u = (_event$kibana2 = event.kibana) === null || _event$kibana2 === void 0 ? void 0 : (_event$kibana2$alert = _event$kibana2.alert) === null || _event$kibana2$alert === void 0 ? void 0 : _event$kibana2$alert.uuid) !== null && _event$kibana$alert$u !== void 0 ? _event$kibana$alert$u : '';
  const menuItems = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "details",
    "data-test-subj": SHOW_DETAILS_TEST_ID,
    onClick: onShowDetails
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.sessionView.detailPanelAlertListItem.showDetailsAction",
    defaultMessage: "View alert details"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "jumpTo",
    "data-test-subj": JUMP_TO_PROCESS_TEST_ID,
    onClick: onJumpToAlert
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.sessionView.detailPanelAlertListItem.jumpToAlert",
    defaultMessage: "Jump to alerted process"
  }))];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: uuid,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      display: "empty",
      size: "s",
      iconType: "boxesHorizontal",
      "aria-label": _i18n.i18n.translate('xpack.sessionView.detailPanelAlertListItem.moreButton', {
        defaultMessage: 'More'
      }),
      "data-test-subj": BUTTON_TEST_ID,
      onClick: onToggleMenu
    }),
    isOpen: isPopoverOpen,
    closePopover: onClosePopover,
    panelPaddingSize: "none",
    anchorPosition: "leftCenter"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: menuItems
  }));
};
exports.DetailPanelAlertActions = DetailPanelAlertActions;