"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerTelemetryUsageCollector = exports.fetchTelemetryMetrics = void 0;
var _searchConnectors = require("@kbn/search-connectors");
var _identify_exceptions = require("@kbn/search-connectors/utils/identify_exceptions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultTelemetryMetrics = {
  native: {
    total: 0
  },
  clients: {
    total: 0
  }
};

/**
 * Register the telemetry collector
 */

const registerTelemetryUsageCollector = usageCollection => {
  const telemetryUsageCollector = usageCollection.makeUsageCollector({
    type: 'connectors_serverless',
    isReady: () => true,
    schema: {
      native: {
        total: {
          type: 'long'
        }
      },
      clients: {
        total: {
          type: 'long'
        }
      }
    },
    async fetch({
      esClient
    }) {
      return await fetchTelemetryMetrics(esClient);
    }
  });
  usageCollection.registerCollector(telemetryUsageCollector);
};

/**
 * Fetch the aggregated telemetry metrics
 */

// @ts-ignore
exports.registerTelemetryUsageCollector = registerTelemetryUsageCollector;
const fetchTelemetryMetrics = async client => {
  try {
    const [nativeCountResponse, clientsCountResponse] = await Promise.all([client.count({
      index: _searchConnectors.CONNECTORS_INDEX,
      query: {
        bool: {
          filter: [{
            term: {
              is_native: true
            }
          }],
          must_not: [{
            term: {
              service_type: {
                value: 'elastic-crawler'
              }
            }
          }]
        }
      }
    }), client.count({
      index: _searchConnectors.CONNECTORS_INDEX,
      query: {
        bool: {
          filter: [{
            term: {
              is_native: false
            }
          }]
        }
      }
    })]);
    return {
      native: {
        total: nativeCountResponse.count
      },
      clients: {
        total: clientsCountResponse.count
      }
    };
  } catch (error) {
    if ((0, _identify_exceptions.isIndexNotFoundException)(error)) {
      return defaultTelemetryMetrics;
    }
  }
};
exports.fetchTelemetryMetrics = fetchTelemetryMetrics;