"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchOverview = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _searchApiPanels = require("@kbn/search-api-panels");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _doc_links = require("../../../common/doc_links");
var _use_kibana = require("../hooks/use_kibana");
var _use_asset_base_path = require("../hooks/use_asset_base_path");
var _constants = require("../constants");
var _java = require("./languages/java");
var _languages = require("./languages/languages");
var _language_grid = require("./languages/language_grid");
require("./overview.scss");
var _api_key = require("./api_key/api_key");
var _connectors_callout = require("./connectors_callout");
var _connectors_ingestion = require("./connectors_ingestion");
var _pipeline_button_overview = require("./pipeline_button_overview");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ElasticsearchOverview = () => {
  const [selectedLanguage, setSelectedLanguage] = (0, _react.useState)(_java.javaDefinition);
  const [clientApiKey, setClientApiKey] = (0, _react.useState)(_constants.API_KEY_PLACEHOLDER);
  const {
    application,
    cloud,
    http,
    user,
    share
  } = (0, _use_kibana.useKibanaServices)();
  const {
    elasticsearchURL,
    cloudId
  } = (0, _react.useMemo)(() => {
    var _cloud$elasticsearchU, _cloud$cloudId;
    return {
      elasticsearchURL: (_cloud$elasticsearchU = cloud === null || cloud === void 0 ? void 0 : cloud.elasticsearchUrl) !== null && _cloud$elasticsearchU !== void 0 ? _cloud$elasticsearchU : _constants.ELASTICSEARCH_URL_PLACEHOLDER,
      cloudId: (_cloud$cloudId = cloud === null || cloud === void 0 ? void 0 : cloud.cloudId) !== null && _cloud$cloudId !== void 0 ? _cloud$cloudId : _constants.CLOUD_ID_PLACEHOLDER
    };
  }, [cloud]);
  const assetBasePath = (0, _use_asset_base_path.useAssetBasePath)();
  const codeSnippetArguments = {
    url: elasticsearchURL,
    apiKey: clientApiKey,
    cloudId
  };
  const {
    hash
  } = (0, _reactRouterDom.useLocation)();
  (0, _react.useEffect)(() => {
    if (hash) {
      const id = hash.replace('#', '');
      const element = document.getElementById(id);
      if (element) {
        element.scrollIntoView({
          behavior: 'smooth'
        });
      }
    }
  }, [hash]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate, {
    offset: 0,
    grow: true,
    restrictWidth: true,
    "data-test-subj": "svlSearchOverviewPage"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    alignment: "top",
    className: "serverlessSearchHeaderSection"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "ghost"
  }, /*#__PURE__*/_react.default.createElement(_searchApiPanels.WelcomeBanner, {
    user: user,
    assetBasePath: assetBasePath
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    color: "subdued",
    bottomBorder: "extended",
    "data-test-subj": "select-client-section"
  }, /*#__PURE__*/_react.default.createElement(_searchApiPanels.SelectClientPanel, {
    docLinks: _doc_links.docLinks,
    http: http,
    callout: /*#__PURE__*/_react.default.createElement(_connectors_callout.ConnectorsCallout, null)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_language_grid.LanguageGrid, {
    assetBasePath: assetBasePath,
    setSelectedLanguage: setSelectedLanguage,
    languages: _languages.languageDefinitions,
    selectedLanguage: selectedLanguage.id
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    color: "subdued",
    bottomBorder: "extended",
    "data-test-subj": "install-client-section"
  }, /*#__PURE__*/_react.default.createElement(_searchApiPanels.InstallClientPanel, {
    codeSnippet: (0, _searchApiPanels.getLanguageDefinitionCodeSnippet)(selectedLanguage, 'installClient', codeSnippetArguments),
    consoleRequest: (0, _searchApiPanels.getConsoleRequest)('installClient'),
    languages: _languages.languageDefinitions,
    language: selectedLanguage,
    setSelectedLanguage: setSelectedLanguage,
    assetBasePath: assetBasePath,
    application: application,
    sharePlugin: share
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    color: "subdued",
    bottomBorder: "extended",
    "data-test-subj": "api-keys-section"
  }, /*#__PURE__*/_react.default.createElement(_searchApiPanels.OverviewPanel, {
    description: _i18n.i18n.translate('xpack.serverlessSearch.apiKey.description', {
      defaultMessage: "An API key is a private, unique identifier for authentication and authorization. You'll need an API key to securely connect to your project."
    }),
    leftPanelContent: /*#__PURE__*/_react.default.createElement(_api_key.ApiKeyPanel, {
      setClientApiKey: setClientApiKey
    }),
    links: [],
    title: _i18n.i18n.translate('xpack.serverlessSearch.apiKey.title', {
      defaultMessage: 'API Key'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    color: "subdued",
    bottomBorder: "extended",
    "data-test-subj": "cloud-details-section"
  }, /*#__PURE__*/_react.default.createElement(_searchApiPanels.CloudDetailsPanel, {
    cloudId: cloud.cloudId,
    elasticsearchUrl: cloud.elasticsearchUrl
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    color: "subdued",
    bottomBorder: "extended",
    "data-test-subj": "configure-client-section"
  }, /*#__PURE__*/_react.default.createElement(_searchApiPanels.OverviewPanel, {
    description: _i18n.i18n.translate('xpack.serverlessSearch.configureClient.description', {
      defaultMessage: 'Initialize your client with your unique API key and Cloud ID'
    }),
    leftPanelContent: /*#__PURE__*/_react.default.createElement(_searchApiPanels.CodeBox, {
      languages: _languages.languageDefinitions,
      codeSnippet: (0, _searchApiPanels.getLanguageDefinitionCodeSnippet)(selectedLanguage, 'configureClient', codeSnippetArguments),
      consoleRequest: (0, _searchApiPanels.getConsoleRequest)('configureClient'),
      selectedLanguage: selectedLanguage,
      setSelectedLanguage: setSelectedLanguage,
      assetBasePath: assetBasePath,
      application: application,
      sharePlugin: share
    }),
    links: [...(selectedLanguage.basicConfig ? [{
      href: selectedLanguage.basicConfig,
      label: _i18n.i18n.translate('xpack.serverlessSearch.configureClient.basicConfigLabel', {
        defaultMessage: 'Basic configuration'
      })
    }] : [])],
    title: _i18n.i18n.translate('xpack.serverlessSearch.configureClient.title', {
      defaultMessage: 'Configure your client'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    color: "subdued",
    bottomBorder: "extended",
    "data-test-subj": "test-client-section"
  }, /*#__PURE__*/_react.default.createElement(_searchApiPanels.OverviewPanel, {
    description: _i18n.i18n.translate('xpack.serverlessSearch.testConnection.description', {
      defaultMessage: 'Send a test request to confirm your language client and Elasticsearch instance are up and running.'
    }),
    leftPanelContent: /*#__PURE__*/_react.default.createElement(_searchApiPanels.CodeBox, {
      languages: _languages.languageDefinitions,
      codeSnippet: (0, _searchApiPanels.getLanguageDefinitionCodeSnippet)(selectedLanguage, 'testConnection', codeSnippetArguments),
      consoleRequest: (0, _searchApiPanels.getConsoleRequest)('testConnection'),
      selectedLanguage: selectedLanguage,
      setSelectedLanguage: setSelectedLanguage,
      assetBasePath: assetBasePath,
      application: application,
      sharePlugin: share
    }),
    links: [],
    title: _i18n.i18n.translate('xpack.serverlessSearch.testConnection.title', {
      defaultMessage: 'Test your connection'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    id: "ingestData",
    color: "subdued",
    bottomBorder: "extended",
    "data-test-subj": "ingest-client-section"
  }, /*#__PURE__*/_react.default.createElement(_searchApiPanels.IngestData, {
    codeSnippet: (0, _searchApiPanels.getLanguageDefinitionCodeSnippet)(selectedLanguage, 'ingestData', codeSnippetArguments),
    consoleRequest: (0, _searchApiPanels.getConsoleRequest)('ingestData'),
    languages: _languages.languageDefinitions,
    selectedLanguage: selectedLanguage,
    setSelectedLanguage: setSelectedLanguage,
    assetBasePath: assetBasePath,
    docLinks: _doc_links.docLinks,
    application: application,
    sharePlugin: share,
    additionalIngestionPanel: /*#__PURE__*/_react.default.createElement(_connectors_ingestion.ConnectorIngestionPanel, {
      assetBasePath: assetBasePath
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    color: "subdued",
    bottomBorder: "extended",
    "data-test-subj": "search-client-section"
  }, /*#__PURE__*/_react.default.createElement(_searchApiPanels.OverviewPanel, {
    description: _i18n.i18n.translate('xpack.serverlessSearch.searchQuery.description', {
      defaultMessage: "Now you're ready to start experimenting with searching and performing aggregations on your Elasticsearch data."
    }),
    leftPanelContent: /*#__PURE__*/_react.default.createElement(_searchApiPanels.CodeBox, {
      languages: _languages.languageDefinitions,
      codeSnippet: (0, _searchApiPanels.getLanguageDefinitionCodeSnippet)(selectedLanguage, 'buildSearchQuery', codeSnippetArguments),
      consoleRequest: (0, _searchApiPanels.getConsoleRequest)('buildSearchQuery'),
      selectedLanguage: selectedLanguage,
      setSelectedLanguage: setSelectedLanguage,
      assetBasePath: assetBasePath,
      application: application,
      sharePlugin: share
    }),
    links: [],
    title: _i18n.i18n.translate('xpack.serverlessSearch.searchQuery.title', {
      defaultMessage: 'Build your first search query'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    color: "subdued",
    bottomBorder: "extended",
    "data-test-subj": "pipeline-client-section"
  }, /*#__PURE__*/_react.default.createElement(_searchApiPanels.OverviewPanel, {
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.serverlessSearch.pipeline.description",
      defaultMessage: "Use {ingestPipelinesLink} to preprocess your data before it's indexed into Elasticsearch, which is often much easier than post-processing. Use any combination of ingest processors to add, delete, or transform fields in your documents.",
      values: {
        ingestPipelinesLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "serverlessSearchElasticsearchOverviewIngestPipelinesLink",
          href: _doc_links.docLinks.ingestionPipelines,
          target: "_blank"
        }, _i18n.i18n.translate('xpack.serverlessSearch.pipeline.description.ingestPipelinesLink.link', {
          defaultMessage: 'ingest pipelines'
        }))
      }
    }),
    leftPanelContent: /*#__PURE__*/_react.default.createElement(_searchApiPanels.PipelinePanel, {
      clusterImage: `${assetBasePath}/cluster.svg`,
      cutImage: `${assetBasePath}/cut.svg`,
      reporterImage: `${assetBasePath}/reporter.svg`
    }),
    links: [],
    title: _i18n.i18n.translate('xpack.serverlessSearch.pipeline.title', {
      defaultMessage: 'Transform and enrich your data'
    }),
    children: /*#__PURE__*/_react.default.createElement(_pipeline_button_overview.PipelineButtonOverview, null)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    alignment: "top",
    className: "serverlessSearchOverviewFooterSection",
    "data-test-subj": "footer-section"
  }, /*#__PURE__*/_react.default.createElement(_searchApiPanels.OverviewPanel, {
    title: _i18n.i18n.translate('xpack.serverlessSearch.overview.footer.title', {
      defaultMessage: 'Do more with your data'
    }),
    description: _i18n.i18n.translate('xpack.serverlessSearch.overview.footer.description', {
      defaultMessage: "Your Elasticsearch endpoint is set up and you've made some basic queries. Now you're ready to dive deeper into more advanced tools and use cases."
    }),
    leftPanelContent: /*#__PURE__*/_react.default.createElement(OverviewFooter, null),
    links: [],
    overviewPanelProps: {
      color: 'transparent',
      hasShadow: false
    }
  })));
};
exports.ElasticsearchOverview = ElasticsearchOverview;
const OverviewFooter = () => {
  const {
    application: {
      navigateToApp
    },
    cloud
  } = (0, _use_kibana.useKibanaServices)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    layout: "horizontal",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
      size: "xl",
      color: "subdued",
      type: "space",
      iconType: "discoverApp",
      iconSize: "original",
      name: "discover"
    }),
    titleSize: "xs",
    title: _i18n.i18n.translate('xpack.serverlessSearch.overview.footer.discover.title', {
      defaultMessage: 'Discover'
    }),
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceAround"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.serverlessSearch.overview.footer.discover.description', {
      defaultMessage: 'Search and filter your data, learn how your fields are structured, and create visualizations.'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "arrowRight",
      color: "subdued"
    }))),
    onClick: () => navigateToApp('discover')
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    layout: "horizontal",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
      size: "xl",
      color: "subdued",
      type: "space",
      iconType: "notebookApp",
      iconSize: "original",
      name: "documentation"
    }),
    titleSize: "xs",
    title: _i18n.i18n.translate('xpack.serverlessSearch.overview.footer.documentation.title', {
      defaultMessage: 'Documentation'
    }),
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceAround"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.serverlessSearch.overview.footer.documentation.description', {
      defaultMessage: 'Learn more with our references, how-to guides, and tutorials.'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "arrowRight",
      color: "subdued"
    }))),
    href: _doc_links.docLinks.gettingStartedSearch
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center"
  }, cloud.usersAndRolesUrl && /*#__PURE__*/_react.default.createElement(FooterButtonContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "serverlessSearchOverviewFooterInviteMoreUsersButton",
    iconType: "users",
    href: cloud.usersAndRolesUrl
  }, _i18n.i18n.translate('xpack.serverlessSearch.overview.footer.links.inviteUsers', {
    defaultMessage: 'Invite more users'
  }))), /*#__PURE__*/_react.default.createElement(FooterButtonContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "serverlessSearchOverviewFooterJoinOurCommunityButton",
    iconType: "heart",
    href: "https://www.elastic.co/community/"
  }, _i18n.i18n.translate('xpack.serverlessSearch.overview.footer.links.community', {
    defaultMessage: 'Join our community'
  }))), /*#__PURE__*/_react.default.createElement(FooterButtonContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "serverlessSearchOverviewFooterGiveFeedbackButton",
    iconType: "faceHappy",
    href: _doc_links.docLinks.kibanaFeedback
  }, _i18n.i18n.translate('xpack.serverlessSearch.overview.footer.links.feedback', {
    defaultMessage: 'Give feedback'
  })))));
};
const FooterButtonContainer = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
  hasShadow: false,
  paddingSize: "none"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, children))));