"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorOverview = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _searchConnectors = require("@kbn/search-connectors");
var _reactQuery = require("@tanstack/react-query");
var _react = _interopRequireWildcard(require("react"));
var _use_connector = require("../../../hooks/api/use_connector");
var _use_sync_jobs = require("../../../hooks/api/use_sync_jobs");
var _use_error_toast = require("../../../hooks/use_error_toast");
var _use_kibana = require("../../../hooks/use_kibana");
var _sync_scheduled_callout = require("./sync_scheduled_callout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorOverview = ({
  connector
}) => {
  const {
    http
  } = (0, _use_kibana.useKibanaServices)();
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    queryKey
  } = (0, _use_connector.useConnector)(connector.id);
  const showErrorToast = (0, _use_error_toast.useShowErrorToast)();
  const {
    data,
    isLoading,
    isSuccess,
    mutate
  } = (0, _reactQuery.useMutation)({
    mutationFn: async () => {
      await http.post(`/internal/serverless_search/connectors/${connector.id}/sync`);
    },
    onError: error => showErrorToast(error, _i18n.i18n.translate('xpack.serverlessSearch.connectors.config.connectorSyncError', {
      defaultMessage: 'Error scheduling sync'
    })),
    onSuccess: () => {
      queryClient.setQueryData(queryKey, {
        connector: {
          ...connector,
          index_name: data
        }
      });
      queryClient.invalidateQueries(queryKey);
    }
  });
  const [pagination, setPagination] = (0, _react.useState)({
    pageIndex: 0,
    pageSize: 20
  });
  const {
    data: syncJobsData,
    isLoading: syncJobsLoading
  } = (0, _use_sync_jobs.useSyncJobs)(connector.id, pagination);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_searchConnectors.SyncJobsTable, {
    isLoading: syncJobsLoading,
    onPaginate: ({
      page
    }) => setPagination({
      pageIndex: page.index,
      pageSize: page.size
    }),
    pagination: syncJobsData ? (0, _searchConnectors.pageToPagination)(syncJobsData === null || syncJobsData === void 0 ? void 0 : syncJobsData._meta.page) : {
      pageIndex: 0,
      pageSize: 20,
      totalItemCount: 0
    },
    syncJobs: (syncJobsData === null || syncJobsData === void 0 ? void 0 : syncJobsData.data) || [],
    type: "content"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "serverlessSearchConnectorOverviewSyncButton",
    color: "primary",
    disabled: [_searchConnectors.ConnectorStatus.CREATED, _searchConnectors.ConnectorStatus.NEEDS_CONFIGURATION].includes(connector.status),
    fill: true,
    isLoading: isLoading,
    onClick: () => mutate()
  }, _i18n.i18n.translate('xpack.serverlessSearch.connectors.config.syncLabel', {
    defaultMessage: 'Sync'
  }))), isSuccess && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_sync_scheduled_callout.SyncScheduledCallOut, null)));
};
exports.ConnectorOverview = ConnectorOverview;