"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorLinkElasticsearch = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("@kbn/search-api-panels/constants");
var _searchConnectors = require("@kbn/search-connectors");
var _react = _interopRequireDefault(require("react"));
var _doc_links = require("../../../../../common/doc_links");
var _use_asset_base_path = require("../../../hooks/use_asset_base_path");
var _use_kibana = require("../../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorLinkElasticsearch = ({
  connectorId,
  serviceType,
  status
}) => {
  var _cloud$elasticsearchU;
  const assetBasePath = (0, _use_asset_base_path.useAssetBasePath)();
  const {
    cloud
  } = (0, _use_kibana.useKibanaServices)();
  const elasticsearchUrl = (_cloud$elasticsearchU = cloud === null || cloud === void 0 ? void 0 : cloud.elasticsearchUrl) !== null && _cloud$elasticsearchU !== void 0 ? _cloud$elasticsearchU : _constants.ELASTICSEARCH_URL_PLACEHOLDER;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.serverlessSearch.connectors.config.link.linkToElasticTitle', {
    defaultMessage: 'Link your connector to Elasticsearch'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, _i18n.i18n.translate('xpack.serverlessSearch.connectors.config.linkToElasticDescription', {
    defaultMessage: 'You need to run the connector code on your own infrastructure and link it to your Elasticsearch instance. You have two options:'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "serverlessSearchConnectorLinkElasticsearchRunWithDockerButton",
    iconType: `${assetBasePath}/docker.svg`,
    href: _doc_links.docLinks.connectors,
    fill: true
  }, _i18n.i18n.translate('xpack.serverlessSearch.connectors.runWithDockerLink', {
    defaultMessage: 'Run with Docker'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "serverlessSearchConnectorLinkElasticsearchRunFromSourceButton",
    iconType: `${assetBasePath}/github_white.svg`,
    href: "https://github.com/elastic/connectors",
    fill: true
  }, _i18n.i18n.translate('xpack.serverlessSearch.connectors.runFromSourceLink', {
    defaultMessage: 'Run from source'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.serverlessSearch.connectors.variablesTitle",
    defaultMessage: "Variables for your {url}",
    values: {
      url: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "elastic/connectors/config.yml")
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, "connector_id"))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, connectorId))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, "service_type"))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, Boolean(serviceType) && /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, serviceType))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, "elasticsearch.host"))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, elasticsearchUrl))), status === _searchConnectors.ConnectorStatus.CREATED && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.serverlessSearch.connectors.waitingForConnection', {
      defaultMessage: 'Waiting for connection'
    }),
    color: "warning",
    iconType: "iInCircle"
  }))))));
};
exports.ConnectorLinkElasticsearch = ConnectorLinkElasticsearch;