"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApiKeyPanel = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = require("@emotion/react");
var _reactQuery = require("@tanstack/react-query");
var _react2 = _interopRequireWildcard(require("react"));
var _use_kibana = require("../../hooks/use_kibana");
var _routes = require("../../../../common/routes");
var _create_api_key_flyout = require("./create_api_key_flyout");
require("./api_key.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ApiKeyPanel = ({
  setClientApiKey
}) => {
  const {
    http,
    user
  } = (0, _use_kibana.useKibanaServices)();
  const [isFlyoutOpen, setIsFlyoutOpen] = (0, _react2.useState)(false);
  const {
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: ['apiKey'],
    queryFn: () => http.fetch('/internal/serverless_search/api_keys')
  });
  const [apiKey, setApiKey] = (0, _react2.useState)(undefined);
  const saveApiKey = value => {
    setApiKey(value);
    if (value.encoded) setClientApiKey(value.encoded);
  };
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, isFlyoutOpen && /*#__PURE__*/_react2.default.createElement(_create_api_key_flyout.CreateApiKeyFlyout, {
    onClose: () => setIsFlyoutOpen(false),
    setApiKey: saveApiKey,
    username: (user === null || user === void 0 ? void 0 : user.full_name) || (user === null || user === void 0 ? void 0 : user.username) || ''
  }), apiKey ? /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    className: "apiKeySuccessPanel",
    "data-test-subj": "api-key-create-success-panel"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiStep, {
    css: (0, _react.css)`
              .euiStep__content {
                padding-bottom: 0;
              }
            `,
    status: "complete",
    headingElement: "h3",
    title: _i18n.i18n.translate('xpack.serverlessSearch.apiKey.apiKeyStepTitle', {
      defaultMessage: 'Store this API key'
    }),
    titleSize: "xs"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.serverlessSearch.apiKey.apiKeyStepDescription', {
    defaultMessage: "You'll only see this key once, so save it somewhere safe. We don't store your API keys, so if you lose a key you'll need to generate a replacement."
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true,
    "data-test-subj": "api-key-created-key-codeblock"
  }, JSON.stringify(apiKey, undefined, 2)))) : /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react2.default.createElement("h3", null, _i18n.i18n.translate('xpack.serverlessSearch.apiKey.panel.title', {
    defaultMessage: 'Add an API Key'
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.serverlessSearch.apiKey.panel.description', {
    defaultMessage: 'Use an existing key, or create a new one and copy it somewhere safe.'
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement("span", null, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    iconType: "plusInCircleFilled",
    size: "s",
    fill: true,
    onClick: () => setIsFlyoutOpen(true),
    "data-test-subj": "new-api-key-button"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.serverlessSearch.apiKey.newButtonLabel', {
    defaultMessage: 'New'
  }))))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement("span", null, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    iconType: "popout",
    size: "s",
    href: http.basePath.prepend(_routes.MANAGEMENT_API_KEYS),
    target: "_blank",
    "data-test-subj": "manage-api-keys-button"
  }, _i18n.i18n.translate('xpack.serverlessSearch.apiKey.manageLabel', {
    defaultMessage: 'Manage'
  })))))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, !!(data !== null && data !== void 0 && data.apiKeys) && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexEnd",
    alignItems: "center"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    size: "s",
    type: "iInCircle",
    color: "subdued"
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.serverlessSearch.apiKey.activeKeys",
    defaultMessage: "You have {number} active keys.",
    values: {
      number: /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
        color: data.apiKeys.length > 0 ? 'success' : 'warning',
        "data-test-subj": "api-keys-count-badge"
      }, data.apiKeys.length)
    }
  }))))))));
};
exports.ApiKeyPanel = ApiKeyPanel;