"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createListSchema = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
var _name = require("../../common/name");
var _description = require("../../common/description");
var _type = require("../../common/type");
var _deserializer = require("../../common/deserializer");
var _id = require("../../common/id");
var _meta = require("../../common/meta");
var _serializer = require("../../common/serializer");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createListSchema = t.intersection([t.exact(t.type({
  description: _description.description,
  name: _name.name,
  type: _type.type
})), t.exact(t.partial({
  deserializer: _deserializer.deserializer,
  // defaults to undefined if not set during decode
  id: _id.id,
  // defaults to undefined if not set during decode
  meta: _meta.meta,
  // defaults to undefined if not set during decode
  serializer: _serializer.serializer,
  // defaults to undefined if not set during decode
  version: _securitysolutionIoTsTypes.DefaultVersionNumber // defaults to a numerical 1 if not set during decode
}))]);
exports.createListSchema = createListSchema;