"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createEndpointListItemSchema = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
var _entries = require("../../common/endpoint/entries");
var _exception_list_item_type = require("../../common/exception_list_item_type");
var _default_create_comments_array = require("../../common/default_create_comments_array");
var _os_type = require("../../common/os_type");
var _description = require("../../common/description");
var _name = require("../../common/name");
var _meta = require("../../common/meta");
var _tags = require("../../common/tags");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createEndpointListItemSchema = t.intersection([t.exact(t.type({
  description: _description.description,
  entries: _entries.nonEmptyEndpointEntriesArray,
  name: _name.name,
  type: _exception_list_item_type.exceptionListItemType
})), t.exact(t.partial({
  comments: _default_create_comments_array.DefaultCreateCommentsArray,
  // defaults to empty array if not set during decode
  item_id: _securitysolutionIoTsTypes.DefaultUuid,
  // defaults to GUID (uuid v4) if not set during decode
  meta: _meta.meta,
  // defaults to undefined if not set during decode
  os_types: _os_type.osTypeArrayOrUndefined,
  // defaults to empty array if not set during decode
  tags: _tags.tags // defaults to empty array if not set during decode
}))]);

// This type is used after a decode since some things are defaults after a decode.
exports.createEndpointListItemSchema = createEndpointListItemSchema;