"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFormatChromeProjectNavNodes = void 0;
var _defaultNavMl = require("@kbn/default-nav-ml");
var _defaultNavDevtools = require("@kbn/default-nav-devtools");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _util = require("../links/util");
var _constants = require("../links/constants");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Closure to access the "up-to-date" chrome.navLinks from services
const getFormatChromeProjectNavNodes = services => {
  const formatChromeProjectNavNodes = (projectNavLinks, path) => {
    const {
      chrome
    } = services;
    return projectNavLinks.reduce((navNodes, navLink) => {
      const {
        id,
        title,
        links
      } = navLink;
      const navLinkId = (0, _util.getNavLinkIdFromProjectPageName)(id);
      if (chrome.navLinks.has(navLinkId)) {
        const link = {
          id: navLinkId,
          title,
          path: path ? [path, navLinkId].join('.') : navLinkId,
          deepLink: chrome.navLinks.get(navLinkId),
          ...((0, _utils.isBreadcrumbHidden)(id) && {
            breadcrumbStatus: 'hidden'
          })
        };
        // check default navigation for children
        const defaultChildrenNav = getDefaultChildrenNav(id, link);
        if (defaultChildrenNav) {
          link.children = defaultChildrenNav;
        } else if (links !== null && links !== void 0 && links.length) {
          link.children = formatChromeProjectNavNodes(links, link.path);
        }
        navNodes.push(link);
      }
      return navNodes;
    }, []);
  };
  const getDefaultChildrenNav = (id, link) => {
    if (id === _securitySolutionNavigation.SecurityPageName.mlLanding) {
      return processDefaultNav(_defaultNavMl.defaultNavigation.children, link.path);
    }
    if (id === _constants.ExternalPageName.devTools) {
      return processDefaultNav(_defaultNavDevtools.defaultNavigation.children, link.path);
    }
    return undefined;
  };
  const processDefaultNav = (children, path) => {
    const {
      chrome
    } = services;
    return children.reduce((navNodes, node) => {
      var _node$id, _node$children;
      const id = (_node$id = node.id) !== null && _node$id !== void 0 ? _node$id : node.link;
      if (!id) {
        return navNodes;
      }
      if (id === 'root') {
        if (node.children) {
          navNodes.push(...processDefaultNav(node.children, path));
        }
        return navNodes;
      }
      const navNode = {
        id,
        title: node.title || '',
        path: [path, id].join('.'),
        breadcrumbStatus: node.breadcrumbStatus,
        getIsActive: node.getIsActive
      };
      if (chrome.navLinks.has(id)) {
        const deepLink = chrome.navLinks.get(id);
        navNode.deepLink = deepLink;
        if (!navNode.title) {
          navNode.title = (deepLink === null || deepLink === void 0 ? void 0 : deepLink.title) || '';
        }
      }
      if ((_node$children = node.children) !== null && _node$children !== void 0 && _node$children.length) {
        navNode.children = processDefaultNav(node.children, navNode.path);
      }
      navNodes.push(navNode);
      return navNodes;
    }, []);
  };
  return formatChromeProjectNavNodes;
};
exports.getFormatChromeProjectNavNodes = getFormatChromeProjectNavNodes;