"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isCloudLink = exports.isBottomNavItemId = exports.getProjectPageNameFromNavLinkId = exports.getProjectFeaturesUrl = exports.getProjectDetails = exports.getNavLinkIdFromProjectPageName = exports.getCloudUrl = exports.getCloudLinkKey = void 0;
var _common = require("@kbn/security-solution-plugin/common");
var _constants = require("./constants");
var _common2 = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getNavLinkIdFromProjectPageName = projectNavLinkId => {
  const cleanId = projectNavLinkId.replace(/\/(.*)$/, ''); // remove any trailing path
  const fullId = cleanId.includes(':') ? cleanId : `${_common.APP_UI_ID}:${cleanId}`; // add the Security appId if not defined
  return fullId.replace(/:$/, ''); // clean trailing separator to app root links to contain the appId alone
};
exports.getNavLinkIdFromProjectPageName = getNavLinkIdFromProjectPageName;
const getProjectPageNameFromNavLinkId = navLinkId => {
  const cleanId = navLinkId.includes(':') ? navLinkId : `${navLinkId}:`; // add trailing separator to app root links that contain the appId alone
  const fullId = cleanId.replace(`${_common.APP_UI_ID}:`, ''); // remove Security appId if present
  return fullId;
};
exports.getProjectPageNameFromNavLinkId = getProjectPageNameFromNavLinkId;
const isCloudLink = linkId => linkId.startsWith('cloud:');
exports.isCloudLink = isCloudLink;
const getCloudLinkKey = linkId => linkId.replace('cloud:', '');
exports.getCloudLinkKey = getCloudLinkKey;
const getCloudUrl = (cloudUrlKey, cloud) => {
  switch (cloudUrlKey) {
    case 'billing':
      return cloud.billingUrl;
    case 'deployment':
      return cloud.deploymentUrl;
    case 'organization':
      return cloud.organizationUrl;
    case 'performance':
      return cloud.performanceUrl;
    case 'profile':
      return cloud.profileUrl;
    case 'usersAndRoles':
      return cloud.usersAndRolesUrl;
    case 'projects':
      return cloud.projectsUrl;
    default:
      return undefined;
  }
};
exports.getCloudUrl = getCloudUrl;
const getProjectDetails = cloud => cloud.serverless;
exports.getProjectDetails = getProjectDetails;
const getProjectFeaturesUrl = cloud => {
  var _getProjectDetails;
  const projectsBaseUrl = getCloudUrl('projects', cloud);
  const projectId = (_getProjectDetails = getProjectDetails(cloud)) === null || _getProjectDetails === void 0 ? void 0 : _getProjectDetails.projectId;
  if (!projectsBaseUrl || !projectId) {
    return undefined;
  }
  return `${projectsBaseUrl}/${_common2.SECURITY_PROJECT_TYPE}/${projectId}?open=securityProjectFeatures`;
};

/**
 * Defines the navigation items that should be in the footer of the side navigation.
 * @todo Make it a new property in the `NavigationLink` type `position?: 'top' | 'bottom' (default: 'top')`
 */
exports.getProjectFeaturesUrl = getProjectFeaturesUrl;
const isBottomNavItemId = id => id === _common.SecurityPageName.landing || id === _constants.ExternalPageName.devTools || id === _constants.ExternalPageName.management || id === _constants.ExternalPageName.integrationsSecurity || id === _constants.ExternalPageName.cloudUsersAndRoles || id === _constants.ExternalPageName.cloudBilling;
exports.isBottomNavItemId = isBottomNavItemId;