"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWelcomeHeaderStyles = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = require("react");
var _launch = _interopRequireDefault(require("../images/launch.png"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useWelcomeHeaderStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const welcomeHeaderStyles = (0, _react2.useMemo)(() => {
    return {
      headerStyles: (0, _react.css)`
        background-image: url(${_launch.default});
        background-size: 40%;
        background-repeat: no-repeat;
        background-position-x: right;
        background-position-y: center;
        padding: ${euiTheme.base * 0.625}px 0;
      `,
      headerTitleStyles: (0, _react.css)`
        padding-bottom: ${euiTheme.size.s};
        font-size: ${euiTheme.base}px;
        color: ${euiTheme.colors.darkShade};
        font-weight: ${euiTheme.font.weight.bold};
        line-height: ${euiTheme.size.l};
      `,
      headerSubtitleStyles: (0, _react.css)`
        font-size: ${euiTheme.base * 2.125}px;
        color: ${euiTheme.colors.title};
        font-weight: ${euiTheme.font.weight.bold};
      `,
      headerDescriptionStyles: (0, _react.css)`
        font-size: ${euiTheme.base}px;
        color: ${euiTheme.colors.subduedText};
        line-height: ${euiTheme.size.l};
        font-weight: ${euiTheme.font.weight.regular};
      `,
      currentPlanWrapperStyles: (0, _react.css)`
        background-color: ${euiTheme.colors.lightestShade};
        border-radius: 56px;
        padding: ${euiTheme.size.xs} ${euiTheme.size.s} ${euiTheme.size.xs} ${euiTheme.size.m};
        height: ${euiTheme.size.xl};
      `,
      currentPlanTextStyles: (0, _react.css)`
        font-size: ${euiTheme.size.m};
        font-weight: ${euiTheme.font.weight.bold};
        padding-right: ${euiTheme.size.xs};
      `
    };
  }, [euiTheme.base, euiTheme.colors.darkShade, euiTheme.colors.lightestShade, euiTheme.colors.subduedText, euiTheme.colors.title, euiTheme.font.weight.bold, euiTheme.font.weight.regular, euiTheme.size.l, euiTheme.size.m, euiTheme.size.s, euiTheme.size.xl, euiTheme.size.xs]);
  return welcomeHeaderStyles;
};
exports.useWelcomeHeaderStyles = useWelcomeHeaderStyles;