"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddIntegrationCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _common = require("@kbn/security-solution-plugin/common");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _add_integrations_callout = require("../styles/add_integrations_callout.styles");
var _translations = require("./translations");
var _types = require("../types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddIntegrationsCalloutComponent = ({
  stepName
}) => {
  const {
    calloutWrapperStyles,
    calloutTitleStyles,
    calloutAnchorStyles
  } = (0, _add_integrations_callout.useAddIntegrationsCalloutStyles)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    navigateTo
  } = (0, _securitySolutionNavigation.useNavigateTo)();
  const toggleStep = (0, _react.useCallback)(() => {
    navigateTo({
      deepLinkId: _common.SecurityPageName.landing,
      path: `#${_types.AddIntegrationsSteps.connectToDataSources}`
    });
  }, [navigateTo]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    className: "eui-displayInlineBlock",
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "m",
      type: "iInCircle",
      color: euiTheme.colors.title,
      className: "eui-alignMiddle"
    }), /*#__PURE__*/_react.default.createElement("span", {
      css: calloutTitleStyles
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolutionServerless.getStarted.addIntegrationCallout.description",
      defaultMessage: "To {stepName} add integrations first {addIntegration}",
      values: {
        addIntegration: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: toggleStep,
          css: calloutAnchorStyles
        }, _translations.ADD_INTEGRATIONS_STEP, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "arrowRight",
          size: "s",
          css: calloutAnchorStyles
        })),
        stepName: stepName !== null && stepName !== void 0 ? stepName : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolutionServerless.getStarted.addIntegrationCallout.link.action",
          defaultMessage: "enable this step"
        })
      }
    }))),
    size: "s",
    css: calloutWrapperStyles
  });
};
const AddIntegrationCallout = /*#__PURE__*/_react.default.memo(AddIntegrationsCalloutComponent);
exports.AddIntegrationCallout = AddIntegrationCallout;