"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CardStep = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _translations = require("../translations");
var _step_content = require("./step_content");
var _use_check_step_completed = require("../hooks/use_check_step_completed");
var _step_context = require("../context/step_context");
var _card_step = require("../styles/card_step.styles");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CardStepComponent = ({
  cardId,
  expandedSteps,
  finishedSteps = new Set(),
  toggleTaskCompleteStatus,
  onStepClicked,
  sectionId,
  step
}) => {
  const {
    navigateTo
  } = (0, _securitySolutionNavigation.useNavigateTo)();
  const isExpandedStep = expandedSteps.has(step.id);
  const {
    id: stepId,
    title,
    description,
    splitPanel,
    icon,
    autoCheckIfStepCompleted
  } = step;
  const hasStepContent = description != null || splitPanel != null;
  const {
    indicesExist
  } = (0, _step_context.useStepContext)();
  (0, _use_check_step_completed.useCheckStepCompleted)({
    autoCheckIfStepCompleted,
    cardId,
    indicesExist,
    sectionId,
    stepId,
    stepTitle: title,
    toggleTaskCompleteStatus
  });
  const isDone = finishedSteps.has(stepId);
  const toggleStep = (0, _react.useCallback)(e => {
    e.preventDefault();
    const newStatus = !isExpandedStep;
    if (hasStepContent) {
      // Toggle step and sync the expanded card step to storage & reducer
      onStepClicked({
        stepId,
        cardId,
        sectionId,
        isExpanded: newStatus
      });
      navigateTo({
        deepLinkId: _securitySolutionNavigation.SecurityPageName.landing,
        path: newStatus ? `#${stepId}` : undefined
      });
    }
  }, [isExpandedStep, hasStepContent, onStepClicked, stepId, cardId, sectionId, navigateTo]);
  const {
    stepPanelStyles,
    stepIconStyles,
    stepTitleStyles,
    allDoneTextStyles,
    toggleButtonStyles,
    getStepGroundStyles,
    stepItemStyles
  } = (0, _card_step.useCardStepStyles)();
  const stepGroundStyles = getStepGroundStyles({
    hasStepContent
  });
  const panelClassNames = (0, _classnames.default)({
    'step-panel-collapsed': !isExpandedStep
  });
  const stepIconClassNames = (0, _classnames.default)('step-icon', {
    'step-icon-done': isDone
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "plain",
    grow: false,
    hasShadow: false,
    borderRadius: "none",
    paddingSize: "none",
    className: panelClassNames,
    id: stepId,
    css: stepPanelStyles
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    css: stepGroundStyles
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    onClick: toggleStep,
    css: stepItemStyles
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: stepIconClassNames,
    css: stepIconStyles
  }, icon && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, (0, _extends2.default)({}, icon, {
    size: "l",
    className: "eui-alignMiddle"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    onClick: toggleStep,
    css: stepItemStyles
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "step-title",
    css: stepTitleStyles
  }, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: stepItemStyles
  }, /*#__PURE__*/_react.default.createElement("div", null, isDone && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    className: "all-done-badge",
    css: allDoneTextStyles,
    color: "success"
  }, _translations.ALL_DONE_TEXT), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    className: "eui-displayInlineBlock toggle-button",
    color: "primary",
    onClick: toggleStep,
    iconType: isExpandedStep ? 'arrowUp' : 'arrowDown',
    "aria-label": isExpandedStep ? _translations.COLLAPSE_STEP_BUTTON_LABEL : _translations.EXPAND_STEP_BUTTON_LABEL,
    size: "xs",
    css: toggleButtonStyles,
    isDisabled: !hasStepContent
  })))), hasStepContent && /*#__PURE__*/_react.default.createElement("div", {
    className: "stepContentWrapper"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "stepContent"
  }, /*#__PURE__*/_react.default.createElement(_step_content.StepContent, {
    autoCheckIfStepCompleted: isExpandedStep ? autoCheckIfStepCompleted : undefined,
    cardId: cardId,
    indicesExist: indicesExist,
    sectionId: sectionId,
    step: step,
    toggleTaskCompleteStatus: toggleTaskCompleteStatus
  }))));
};
const CardStep = /*#__PURE__*/_react.default.memo(CardStepComponent);
exports.CardStep = CardStep;