"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getProductBadges = exports.edrBadge = exports.cloudBadge = exports.analyticsBadge = void 0;
var _product = require("../../common/product");
var _translations = require("./translations");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const analyticsBadge = {
  id: _types.BadgeId.analytics,
  name: _translations.PRODUCT_BADGE_ANALYTICS
};
exports.analyticsBadge = analyticsBadge;
const cloudBadge = {
  id: _types.BadgeId.cloud,
  name: _translations.PRODUCT_BADGE_CLOUD
};
exports.cloudBadge = cloudBadge;
const edrBadge = {
  id: _types.BadgeId.edr,
  name: _translations.PRODUCT_BADGE_EDR
};
exports.edrBadge = edrBadge;
const productBadges = {
  [_product.ProductLine.security]: analyticsBadge,
  [_product.ProductLine.cloud]: cloudBadge,
  [_product.ProductLine.endpoint]: edrBadge
};
const getProductBadges = productLineRequired => (productLineRequired !== null && productLineRequired !== void 0 ? productLineRequired : [_product.ProductLine.security, _product.ProductLine.cloud, _product.ProductLine.endpoint]).map(product => productBadges[product]);
exports.getProductBadges = getProductBadges;